ORCA/M Asm65816 2.1.0

0001 4785              ****************************************************************
0002 4785              *                                                              *
0003 4785              *              Copyright (C) 1989-1992                         *
0004 4785              *              All Rights Reserved                             *
0005 4785              *              Apple Computer, Inc.                            *
0006 4785              *                                                              *
0007 4785              ****************************************************************
0008 4785
0009 4785                       title 'Menu Mgr Patch        GS ROM 3 Patch' 
0010 4785              ******************************************************************
0011 4785              *
0012 4785              *                   Menu manager patches for ROM 3
0013 4785              *
0014 4785              * System Disk 5.0
0015 4785              *
0016 4785              * 5/16/89           Everyone
0017 4785              *
0018 4785              * Patch to PopUpMenuSelect to fix two bugs.  First, there
0019 4785              * is a problem with the code that restores behind a popup
0020 4785              * if the popup falls off the screen.  It restores too much.
0021 4785              *
0022 4785              * Second, there was a field that was not initialized and the
0023 4785              * first rectangle drawn could be drawn in the wrong place.
0024 4785              *
0025 4785              * 19 May 89         Steven Glass
0026 4785              *
0027 4785              * HiliteMenu did not work if the input was 0 or FFFF, we now
0028 4785              * special case these and clean the stack instead of crashing.
0029 4785              *
0030 4785              * 23 May 89         Yee
0031 4785              *
0032 4785              * Take out patch to HiliteMenu because some applications 
0033 4785              * actually create menus with an ID of zero (which by the 
0034 4785              * way is not legal, i.e. of app is BounceIt)
0035 4785              *
0036 4785              * 25 May 89         Mensch and Yee (thanks for including me in the journey)
0037 4785              *
0038 4785              * Patched out a shit load of calls to fix the problem where
0039 4785              * the handle to menu caches were being orphaned.
0040 4785              * For all the calls that call the routines freeCache and
0041 4785              * everycachefree we patch those calls out. In the patch we save 
0042 4785              * all the caches to each menu and then make sure we return back to 
0043 4785              * the patch so we can compare each saved cache to the cache currently 
0044 4785              * in each menu if they differ then that handle is disposed of.
0045 4785              *
0046 4785              * 31 May 89         Mensch and Yee
0047 4785              * 
0048 4785              * Make menu manager patch scrambler proof. We were not dereferencing
0049 4785              * the menu bar handle before using it. (Change made in SaveAllCache,
0050 4785              * we deref right before calling GetMFirst)
0051 4785              *
0052 4785              * Take prototype bit out of version number. Final version = 3.1 for
0053 4785              * System Disk 5.0.
0054 4785              *
0055 4785              * 07 Sep 89         Yee
0056 4785              *
0057 4785              * Patch NewMenuBar2. When the menubar is a resource, the resource
0058 4785              * is not getting released properly. If the high word of the resource
0059 4785              * ID is non-zero then we crash. If the high word is zero then the 
0060 4785              * resource just doesn't get released. This has been fixed.
0061 4785              *
0062 4785              * 08 Mar 90         Yee
0063 4785              *
0064 4785              * Install patch for icon support. You can now have icons in menu items.
0065 4785              * Added the calls SetItemIcon and GetItemIcon. 
0066 4785              *
0067 4785              * 13 Mar 90 
0068 4785              *
0069 4785              * Added the following calls: SetItemStruct($490F), GetItemStruct($4A0F),
0070 4785              * RemoveItemStruct($4B0F), GetItemFlag2($4C0F), and SetItemFlag2($4D0F).
0071 4785              *
0072 4785              * Patched the following existing calls: SetMItem, GetMItem, SetMItemName,
0073 4785              * SetMItemName2, and CalcMenuSize.
0074 4785              *
0075 4785              * 21 Mar 90         Yee
0076 4785              * Fix bug in CalcMenuSize. Worksheet #MTLRAF013. I was referencing <itemptr
0077 4785              * when it hadn't been setup yet.
0078 4785              *
0079 4785              * 29 Mar 90         Yee
0080 4785              * Fix bug in DeleteMenu. The handle of the menu getting removed from 
0081 4785              * the menu list was not getting unlocked.
0082 4785              *
0083 4785              * 05 Apr 90         Yee
0084 4785              * Change the way the menu item icons are drawn. I now use DrawIcon instead
0085 4785              * of PPToPort to draw the icon. To use icons in menu items, the menu mgr
0086 4785              * now requires that QDAux be started. Also the icon structure use to look
0087 4785              * like a locInfo record, its now an icon structure as defined by rIcon.
0088 4785              *
0089 4785              * 17-Sep-90         Dave Lyons
0090 4785              *
0091 4785              * Changed e16.resource to e16.resources.  Removed all.macros.
0092 4785              * Version is $8303.
0093 4785              *
0094 4785              * 19-Sep-90         Dave Lyons
0095 4785              *
0096 4785              * Added GetMItemBlink call.
0097 4785              * Added code to MenuSelect patch to call InitCursor if the G_INITCURSOR
0098 4785              * bit is set in the Menu Global flags and the cursor doesn't seem to
0099 4785              * already be the arrow cursor.
0100 4785              *
0101 4785              * 22-Oct-90         Dave Lyons
0102 4785              *
0103 4785              * Patched EnableMItem and DisableMItem to return error $0001 if the
0104 4785              * Menu Manager isn't started up yet (for compatibility with a stupid
0105 4785              * third-party application).
0106 4785              *
0107 4785              * 10-Jan-91         Dave Lyons
0108 4785              *
0109 4785              * Adding InsertPathMItems call (see Menu Manager source).
0110 4785              *
0111 4785              * 17-Jan-91         Dave Lyons
0112 4785              *
0113 4785              * Patched PopUpMenuSelect to disable fastPorting, because the ROM
0114 4785              * Menu Mgr is stuffing a bunch of values into the grafPort & not
0115 4785              * letting QD know about it.  This was making items not always
0116 4785              * hilite properly in pop-ups, at least when the items had icons.
0117 4785              *
0118 4785              * 17-Feb-91         Dave Lyons
0119 4785              *
0120 4785              * Postpatched MenuStartUp to set item blink from BRAM $5E, bits 3-4.
0121 4785              *
0122 4785              * 3-Mar-91          Dave Lyons
0123 4785              *
0124 4785              * Patched MenuKey to call SendRequest($0F01) if no menu item is found
0125 4785              * matching the key.
0126 4785              *
0127 4785              * 14-Mar-91         Dave Lyons
0128 4785              *
0129 4785              * If the MenuKey SendRequest call succeeds, now I change the event
0130 4785              * into a null event so the caller doesn't try to handle it further.
0131 4785              *
0132 4785              * 15-May-91         Dave Lyons
0133 4785              *
0134 4785              * Fix InsertMenu to return dupMenuID on a duplicate menu ID being
0135 4785              * inserted.
0136 4785              *
0137 4785              * 21-May-91         Dave Lyons
0138 4785              *
0139 4785              * Mask off high byte of the SetPurge parameter for a pop-up.
0140 4785              * SetPurge was returning an error, since bit 31 is a flag here.
0141 4785              *
0142 4785              * 22-May-91         Dave Lyons
0143 4785              *
0144 4785              * Added a PHA I left out yesterday ("dumbshit move" sez Greg).
0145 4785              *
0146 4785              * 25-Jul-91         Dave Lyons
0147 4785              *
0148 4785              * Added restrictions to SendRequest($0F01=systemSaysMenuKey): Desk Manager must
0149 4785              * be active, CDA-events must be postable (for Installer when it disables use
0150 4785              * of DAs), and we must be dealing with the system menu bar.
0151 4785              *
0152 4785              * 2-Aug-91          Dave Lyons
0153 4785              *
0154 4785              * Fix above code--direct page wasn't set in this context (code was pasted in
0155 4785              * from TOOL015).
0156 4785              *
0157 4785              * 26-Aug-91         Dave Lyons
0158 4785              *
0159 4785              * HideMenuBar now messes only with SCBs 2 through 9, instead of setting them all
0160 4785              * to the MasterSCB.
0161 4785              *
0162 4785              * SendRequest(systemSaysMenuKey) now has stop-after-one flag set.
0163 4785              *
0164 4785              * 18-Sep-91         Dave Lyons
0165 4785              *
0166 4785              * Made HideMenuBar mess with SCBs 0..MenuBarHeight-1, instead of just 2..9.
0167 4785              * This is for HyperCard IIgs compatibility.
0168 4785              *
0169 4785              * ??-Dec-91         Dave Lyons
0170 4785              *
0171 4785              * Cleaned up some comments & dead text.
0172 4785              *
0173 4785              * 8-Feb-92          Dave Lyons
0174 4785              *
0175 4785              * Pre-patch MenuSelect to not pull down a menu so close to the
0176 4785              * bottom of the screen that we trash stuff past the end of screen
0177 4785              * memory.
0178 4785              *
0179 4785              * Patch PopUpMenuSelect so it correctly gives the mGetItemID
0180 4785              * message to custom pop-ups.
0181 4785              *
0182 4785              * Version $0303 for 6.0.
0183 4785              *
0184 4785              ******************************************************************
0185 4785              *
0186 4785              * 13-Mar-92         Dave Lyons
0187 4785              *
0188 4785              * Version $8304 for 6.0.1.
0189 4785              *
0190 4785              * 2-Apr-93 DAL
0191 4785              *
0192 4785              * Version $0304 for 6.0.1.
0193 4785              *
0194 4785              ******************************************************************
0195 4785                       Blanks off 
0196 4785                       String asis 
0197 4785
0198 4785                       include 'all.macros'           ;16-Jan-91 DAL
0199 4785
0200 4785                       include 'e16.resources' 
0201 4785                       include 'e16.qdaux' 
0202 4785                       include ':::MenuMgr:MenuEquates.asm' 
0203 4785
0204 4785                       import FinishSetForeColor 
0205 4785                       import FinishPtInRect 
0206 4785
0207 4785
0208 4785              dispCtl  EQU $0004                      ; DefProc - Dispose command.
0209 4785
0210 4785              ToStrip  equ   $E10184                  ; Jmp vector to 0ErrOut routine
0211 4785
0212 4785              UnlockMenuBar equ   $FD62C4
0213 4785              LockMenuHand equ   $FD62F1
0214 4785              UnlockMenuHand equ   $FD6303
0215 4785              DerefMenuHand equ   $FD6315
0216 4785              LockMenuBar equ   $FD628B
0217 4785              Cache    equ   $FD7D33
0218 4785              MakeCache equ   $FD802F
0219 4785              AllocateCache equ   $FD8052
0220 4785              FreeCache equ   $FD80CF
0221 4785              DoWhiteSpace equ   $FD69D9
0222 4785              JustifyRight equ   $FD6F0D
0223 4785              JustifyLeft equ   $FD6EFB
0224 4785              AdjustBottom equ   $FD6B5F
0225 4785              AdjustTop equ   $FD6B12
0226 4785              AdjustRect equ   $FD6BAA
0227 4785              GetIFirst equ   $FD7425
0228 4785              Next_Item equ   $FD7437
0229 4785              Dispatch equ   $FD6FC5
0230 4785              InitStuff equ   $FD6A61
0231 4785              GetColor equ   $FD6376
0232 4785              SaveColor equ   $FD6A46
0233 4785              GetMFirst equ   $FD6235
0234 4785              Next_Menu equ   $FD6887
0235 4785              FixTextFace equ   $FD8104
0236 4785              PrintStrg equ   $FD7D1E
0237 4785              LoadnRelease equ   $FD5BC4
0238 4785              GetItemH equ   $FD740D
0239 4785              IntoSizeMenu equ   $FD711C
0240 4785              to_uport equ   $FD635C
0241 4785              to_myport equ   $FD6327
0242 4785              getmptr  equ   $FD6238
0243 4785              hline    equ   $FD7446
0244 4785              calcitem equ   $FD73AD
0245 4785              inside   equ   $FD6CBD
0246 4785              getiptr  equ   $FD79BF
0247 4785              badCache equ   $FD8092
0248 4785              parse_strg equ   $FD5CB4
0249 4785              growBlock equ   $FD7714
0250 4785
0251 4785              BackIntoRomSucker equ   $FD6DEC
0252 4785              PopEmptyInROM equ   $FD69B1
0253 4785              RightAfterPullDown2Call equ $FD6988  
0254 4785
0255 4785
0256 4785              TheRTL   equ   $FD577B
0257 4785
0258 4785              ROMMenuNewres equ   $FD57EB
0259 4785              ROMInsertMenu equ   $FD75E2
0260 4785              ROMSetMTitleStart equ   $FD781A
0261 4785              ROMSetMTitleWidth equ   $FD7883
0262 4785              ROMSetMenuTitle equ   $FD795D
0263 4785              ROMSetMenuTitle2 equ   $FD7901
0264 4785              ROMCalcMenuSize equ   $FD74E6
0265 4785              ROMInsertMItem equ   $FD7564
0266 4785              ROMInsertMItem2 equ   $FD753A
0267 4785              ROMDeleteMItem equ   $FD764F
0268 4785              ROMDeleteMenu equ   $FD76D7
0269 4785              ;;;ROMMenuSelect	equ	$FD6BBF
0270 4785
0271 4785              pop0Bytes equ   $FD8FA3
0272 4785              pop2Bytes equ   $FD8FAB
0273 4785              pop4Bytes equ   $FD8FB3
0274 4785              pop6Bytes equ   $FD8FBB
0275 4785              pop8Bytes equ   $FD8FC3
0276 4785              popABytes equ   $FD8FCB
0277 4785              epop2bytes equ   $FD8FAE
0278 4785              epop8bytes equ   $FD8FC6
0279 4785
0280 4785
0281 4785              ;===========================================================================
0282 4785              ;          Menu Manager function table.
0283 4785              ;===========================================================================
0284 4785              MenuCallTable PROC EXPORT 
0285 4785                       import PopupMenuSelect 
0286 4785                       import MenuVersion 
0287 4785                       import MenuSelect 
0288 4785                       import HiliteMenu 
0289 4785                       import MenuNewRes 
0290 4785                       import InsertMenu 
0291 4785                       import SetMTitleStart 
0292 4785                       import SetMTitleWidth 
0293 4785                       import SetMenuTitle2 
0294 4785                       import SetMenuTitle 
0295 4785                       Import CalcMenuSize 
0296 4785                       import InsertMItem 
0297 4785                       import InsertMItem2 
0298 4785                       import deleteMItem 
0299 4785                       import DeleteMenu 
0300 4785                       import MenuStartUp 
0301 4785                       import MenuShutDown 
0302 4785                       import GetPopupDefProc 
0303 4785                       import NewMenuBar2 
0304 4785                       import SetItemIcon 
0305 4785                       import GetItemIcon 
0306 4785                       import SetItemStruct 
0307 4785                       import GetItemStruct 
0308 4785                       import RemoveItemStruct 
0309 4785                       import GetItemFlag2 
0310 4785                       import SetItemFlag2 
0311 4785                       import SetMItem 
0312 4785                       import GetItem 
0313 4785                       import SetMItemName 
0314 4785                       import SetMItemName2 
0315 4785                       import SetMItem2 
0316 4785                       import GetItemWidth 
0317 4785                       import GetMItemBlink 
0318 4785                       import EnableMItem 
0319 4785                       import DisableMItem 
0320 4785                       import InsertPathMItems        ;10-Jan-91 DAL
0321 4785                       import MenuKey                 ;3-Mar-91 DAL
0322 4785                       import HideMenuBar             ;26-Aug-91 DAL
0323 4785
0324 4785                       ENTRY FPT 
0325 4785 51 00 00 00  FPT      DC L:(ENDFPT-FPT)/4
0326 4789 00 00 00 00           DC L:0                          ;  MenuBootInit      $010F
0327 478D D6 4D 02 00           DC L:MenuStartUp-1              ;  MenuStartUp       $020F
0328 4791 0C 4E 02 00           DC L:MenuShutDown-1             ;  MenuShutDown      $030F
0329 4795 C8 4B 02 00           DC L:MenuVersion-1              ;                    $040F
0330 4799 00 00 00 00           DC L:0                          ;  MenuReset         $050F
0331 479D 00 00 00 00           DC L:0                          ;  MenuStatus        $060F
0332 47A1 00 00 00 00           DC L:0                          ;  Reserved          $070F
0333 47A5 00 00 00 00           DC L:0                          ;  Reserved          $080F
0334 47A9 D2 4B 02 00           DC L:MenuKey-1                  ;                    $090F patched 3-Mar-91 DAL
0335 47AD 00 00 00 00           DC L:0                          ;  GetMenuBar        $0A0F
0336 47B1 00 00 00 00           DC L:0                          ;  MenuRefresh       $0B0F
0337 47B5 00 00 00 00           DC L:0                          ;  FlashMenuBar      $0C0F
0338 47B9 2D 52 02 00           DC L:InsertMenu-1               ;  InsertMenu        $0D0F
0339 47BD 97 4E 02 00           DC L:DeleteMenu-1               ;  DeleteMenu        $0E0F
0340 47C1 2C 4F 02 00           DC L:InsertMItem-1              ;  InsertMItem       $0F0F
0341 47C5 07 4F 02 00           DC L:DeleteMItem-1              ;  DeleteMItem       $100F
0342 47C9 00 00 00 00           DC L:0                          ;  GetSysBar         $110F
0343 47CD 00 00 00 00           DC L:0                          ;  SetSysBar         $120F
0344 47D1 00 00 00 00           DC L:0                          ;  FixMenuBar        $130F
0345 47D5 00 00 00 00           DC L:0                          ;  CountMItems       $140F
0346 47D9 00 00 00 00           DC L:0                          ;  NewMenuBar        $150F
0347 47DD 00 00 00 00           DC L:0                          ;  GetMHandle        $160F
0348 47E1 00 00 00 00           DC L:0                          ;  SetBarColors      $170F
0349 47E5 00 00 00 00           DC L:0                          ;  GetBarColors      $180F
0350 47E9 08 52 02 00           DC L:SetMTitleStart-1           ;                    $190F
0351 47ED 00 00 00 00           DC L:0                          ;  GetMTitleStart    $1A0F
0352 47F1 00 00 00 00           DC L:0                          ;  GetMenuMgrPort    $1B0F
0353 47F5 28 51 02 00           DC L:CalcMenuSize-1             ;  CalcMenuSize      $1C0F
0354 47F9 E1 51 02 00           DC L:SetMTitleWidth-1           ;                    $1D0F
0355 47FD 00 00 00 00           DC L:0                          ;  GetMTitleWidth    $1E0F
0356 4801 00 00 00 00           DC L:0                          ;  SetMenuFlag       $1F0F
0357 4805 00 00 00 00           DC L:0                          ;  GetMenuFlag       $200F
0358 4809 8D 51 02 00           DC L:SetMenuTitle-1             ;  SetMenuTitle      $210F
0359 480D 00 00 00 00           DC L:0                          ;  GetMenuTitle      $220F
0360 4811 00 00 00 00           DC L:0                          ;  MenuGlobal        $230F     Added 2/18/87
0361 4815 5C 5A 02 00           DC L:SetMItem-1                 ;                    $240F
0362 4819 D0 5A 02 00           DC L:GetItem-1                  ;                    $250F
0363 481D 00 00 00 00           DC L:0                          ;  SetMItemFlag      $260F
0364 4821 00 00 00 00           DC L:0                          ;  GetItemFlag       $270F
0365 4825 00 00 00 00           DC L:0                          ;  SetItemBlink      $280F
0366 4829 2E 4E 02 00           DC L:MenuNewRes-1               ;  MenuNewRes        $290F
0367 482D 00 00 00 00           DC L:0                          ;  DrawMenuBar       $2A0F
0368 4831 91 52 02 00           DC L:MenuSelect-1               ;  MenuSelect        $2B0F
0369 4835 00 00 00 00           DC L:0                          ;  HiliteMenu        $2C0F
0370 4839 00 00 00 00           DC L:0                          ;  NewMenu           $2D0F
0371 483D 00 00 00 00           DC L:0                          ;  DisposeMenu       $2E0F
0372 4841 00 00 00 00           DC L:0                          ;  InitPalette       $2F0F
0373 4845 20 5B 02 00           DC L:EnableMItem-1              ;                    $300F patched 22-Oct-90 DAL
0374 4849 2C 5B 02 00           DC L:DisableMItem-1             ;                    $310F patched 22-Oct-90 DAL
0375 484D 00 00 00 00           DC L:0                          ;  CheckMItem        $320F
0376 4851 00 00 00 00           DC L:0                          ;  SetMItemMark      $330F
0377 4855 00 00 00 00           DC L:0                          ;  GetItemMark       $340F
0378 4859 00 00 00 00           DC L:0                          ;  SetMItemStyle     $350F
0379 485D 00 00 00 00           DC L:0                          ;  GetItemStyle      $360F
0380 4861 00 00 00 00           DC L:0                          ;  SetMenuID         $370F
0381 4865 00 00 00 00           DC L:0                          ;  SetItemID         $380F
0382 4869 00 00 00 00           DC L:0                          ;  SetMenuBar        $390F
0383 486D 33 5B 02 00           DC L:SetMItemName-1             ;                    $3A0F
0384 4871
0385 4871              ******* Adding new calls for System Disk 4.1 a.k.a. 5.0 *********
0386 4871
0387 4871 8C 56 02 00           DC L:GetPopUpDefProc-1          ;                    $3B0F
0388 4875 D7 53 02 00           DC L:PopUpMenuSelect-1          ;                    $3C0F
0389 4879 00 00 00 00           DC L:0                          ;  Hole              $3D0F used to be DrawPopUp call
0390 487D 00 00 00 00           DC L:0                          ;  NewMenu2          $3E0F
0391 4881 57 4F 02 00           DC L:InsertMItem2-1             ;  InsertMItem2      $3F0F
0392 4885 B6 51 02 00           DC L:SetMenuTitle2-1            ;                    $400F
0393 4889 EF 5B 02 00           DC L:SetMItem2-1                ;                    $410F
0394 488D 94 5B 02 00           DC L:SetMItemName2-1            ;                    $420F
0395 4891 1D 53 02 00           DC L:NewMenuBar2-1              ;                    $430F
0396 4895 00 00 00 00           DC L:0                          ;  GetResMTitle      $440F
0397 4899 6D 53 02 00           DC L:HideMenuBar-1              ;                    $450F patched 26-Aug-91 DAL
0398 489D 00 00 00 00           DC L:0                          ;  ShowMenuBar       $460F
0399 48A1
0400 48A1              *** new calls for System Disk 6.0 ***
0401 48A1
0402 48A1 CA 57 02 00           DC L:SetItemIcon-1              ;                    $470F New calls to support
0403 48A5 3F 58 02 00           DC L:GetItemIcon-1              ;                    $480F icons in menu items.
0404 48A9 AB 58 02 00           DC L:SetItemStruct-1            ;                    $490F
0405 48AD 15 59 02 00           DC L:GetItemStruct-1            ;                    $4A0F
0406 48B1 61 59 02 00           DC L:RemoveItemStruct-1         ;                    $4B0F
0407 48B5 C6 59 02 00           DC L:GetItemFlag2-1             ;                    $4C0F
0408 48B9 0D 5A 02 00           DC L:SetItemFlag2-1             ;                    $4D0F
0409 48BD 5A 5A 02 00           DC L:GetItemWidth-1             ;                    $4E0F (Harry's call?? Added 19-Sep-90 DAL)
0410 48C1 71 4C 02 00           DC L:GetMItemBlink-1            ;                    $4F0F Added 19-Sep-90 DAL
0411 48C5 02 5D 02 00           DC L:InsertPathMItems-1         ;                    $500F Added 10-Jan-91 DAL
0412 48C9              ENDFPT    
0413 48C9                       ENDP 
0414 48C9
0415 48C9
0416 48C9              ****************************************************************
0417 48C9              *
0418 48C9              MenuVersion Proc 
0419 48C9              *
0420 48C9              * Returns the version number of the menu manager.
0421 48C9              *
0422 48C9              *
0423 48C9              * Inputs:
0424 48C9              *                   none
0425 48C9              *
0426 48C9              * Outputs:
0427 48C9              *                   version number on stack
0428 48C9              *
0429 48C9              * External Refs:
0430 48C9              *                   none
0431 48C9              *
0432 48C9              * Entry Points:
0433 48C9              *                   none
0434 48C9              *
0435 48C9                       longa on                       ; mode
0436 48C9                       longi on 
0437 48C9              *
0438 48C9              ****************************************************************
0439 48C9
0440 48C9
0441 48C9 A9 04 03              lda   #$0304                   ;2-Apr-93 DAL
0442 48CC 83 07                 sta   7,s
0443 48CE
0444 48CE                       ENTRY QuickReturn 
0445 48CE              QuickReturn  
0446 48CE A9 00 00              lda   #0
0447 48D1 18                    clc   
0448 48D2 6B                    rtl   
0449 48D3
0450 48D3                       ENDP 
0451 48D3
0452 48D3
0453 48D3              ;===========================================================================
0454 48D3              ;
0455 48D3              ;                   MenuKey
0456 48D3              ;
0457 48D3              ;   IN:  Task Record, Menu Bar Handle
0458 48D3              ;
0459 48D3              ;  OUT:  none
0460 48D3              ;
0461 48D3              ; (New patch 3-Mar-91 DAL)
0462 48D3              ;
0463 48D3              ;===========================================================================
0464 48D3              MenuKey  proc 
0465 48D3
0466 48D3 AA                    tax                            ;save WAP
0467 48D4 A3 0D                 lda   13,s
0468 48D6 48                    pha   
0469 48D7 A3 0D                 lda   13,s
0470 48D9 48                    pha                            ;pushed copy of task record
0471 48DA A3 0D                 lda   13,s
0472 48DC 48                    pha   
0473 48DD A3 0D                 lda   13,s
0474 48DF 48                    pha                            ;pushed copy of Menu Bar handle
0475 48E0 8A                    txa                            ;restore WAP
0476 48E1 22 6D 4C 02           jsl   @toROM
0477 48E5 B0 7E                 bcs   @exit
0478 48E7
0479 48E7 0B                    phd   
0480 48E8 3B                    tsc   
0481 48E9 5B                    tcd   
0482 48EA              @taskRec equ   11+2
0483 48EA A0 10 00              ldy   #$10                     ;offset to TaskData field
0484 48ED B7 0D                 lda   [@taskRec],y
0485 48EF D0 70                 bne   @claimed
0486 48F1 A0 0E 00              ldy   #$0E                     ;offset to modifiers
0487 48F4 B7 0D                 lda   [@taskRec],y
0488 48F6 29 00 01              and   #$0100                   ;Apple key down?
0489 48F9 F0 66                 beq   @noAppleKey
0490 48FB
0491 48FB              *** 25-Jul-91 DAL -- more restrictions on SendRequest($0F01):
0492 48FB              ***   Desk Manager must be active, CDA-events must be postable (for Installer),
0493 48FB              ***   and we must be dealing with the system menu bar
0494 48FB 48                    pha   
0495 48FC A2 05 06 22           _DeskStatus 
0496 4903 68                    pla   
0497 4904 F0 5B                 beq   @notSafe
0498 4906
0499 4906 48                    pha   
0500 4907 48                    pha   
0501 4908 F4 00 00              pea   0
0502 490B F4 06 00              pea   6                        ;Event Manager
0503 490E A2 01 0C 22           _GetWAP 
0504 4915 FA                    plx   
0505 4916 68                    pla   
0506 4917 BF 22 00 00           lda   >$000022,x
0507 491B 29 00 04              and   #$0400                   ;check OS Event Mask
0508 491E F0 41                 beq   @notSafe                 ;no CDA events allowed?
0509 4920
0510 4920              *** 2-Aug-91 DAL -- our direct page isn't set!  Use X.
0511 4920 48                    pha   
0512 4921 48                    pha                            ;space for GetWAP
0513 4922 F4 00 00              pea   0                        ;system tool
0514 4925 F4 0F 00              pea   $0F                      ;Menu Manager
0515 4928 A2 01 0C 22           _GetWAP 
0516 492F FA                    plx   
0517 4930 68                    pla   
0518 4931
0519 4931 BF 08 00 00           lda   >sysmenu,x
0520 4935 DF 18 00 00           cmp   >barhand,x
0521 4939 D0 26                 bne   @notSafe
0522 493B BF 0A 00 00           lda   >sysmenu+2,x
0523 493F DF 1A 00 00           cmp   >barhand+2,x
0524 4943 D0 1C                 bne   @notSafe
0525 4945              *** end 2-Aug-91
0526 4945              *** end 25-Jul-91 DAL
0527 4945
0528 4945              *** since Apple was down & no item was chosen, give SendRequest($0F01) a shot at it
0529 4945 F4 01 0F              pea   $0F01                    ;RequestCode for unclaimed MenuKey
0530 4948 F4 00 80              pea   $8000                    ;How=$8000: send to everyone, stop after one (26-Aug-91 DAL)
0531 494B A9 00 00              lda   #0
0532 494E 48                    pha   
0533 494F 48                    pha                            ;target=0 (reserved)
0534 4950 D4 0F                 pei   <@taskRec+2
0535 4952 D4 0D                 pei   <@taskRec                ;data in = event pointer
0536 4954 48                    pha   
0537 4955 48                    pha                            ;data out = nil
0538 4956 A2 01 1C 22           _SendRequest 
0539 495D              *** added 14-Mar-91 DAL--if a request proc takes the event, turn it into a null event
0540 495D B0 02                 bcs   @notTaken
0541 495F 87 0D                 sta   [<@taskRec]              ;zero it out
0542 4961              @notTaken  
0543 4961              @notSafe  
0544 4961              *** end of 14-Mar-91 DAL
0545 4961              @noAppleKey  
0546 4961 2B           @claimed pld   
0547 4962
0548 4962 A9 00 00              lda   #0
0549 4965 AA           @exit    tax   
0550 4966 A0 08 00              ldy   #8
0551 4969 5C 84 01 E1           jml   $e10184                  ;ToStrip
0552 496D
0553 496D 22 38 6C FD  @toROM   jsl   $fd6c38                  ;original ROM 3 MenuKey
0554 4971 6B                    rtl   
0555 4972
0556 4972                       EndP 
0557 4972
0558 4972              ;===========================================================================
0559 4972              ;
0560 4972              ;                   GetItemBlink
0561 4972              ;
0562 4972              ;   IN:  none
0563 4972              ;
0564 4972              ;  OUT:  blink value (word).
0565 4972              ;
0566 4972              ; (New call 19-Sep-90 DAL)
0567 4972              ;
0568 4972              ;===========================================================================
0569 4972              GetMItemBlink PROC 
0570 4972
0571 4972              result   equ   7
0572 4972
0573 4972 AA                    tax                            ;point X at our direct page
0574 4973 BF 38 00 00           lda   >blink,x                 ;loads from Blink on Menu Mgr DP
0575 4977 83 07                 sta   result,s
0576 4979 18                    clc   
0577 497A A9 00 00              lda   #0
0578 497D 6B                    rtl   
0579 497E
0580 497E                       ENDP 
0581 497E
0582 497E
0583 497E              CacheFixData record 
0584 497E 00 00        NumCache DS W:1
0585 4980 00 00 00 00  LocalCache DS L:16
0586 49C0 00 00        CountTemp DS W:1
0587 49C2              NumInList  
0588 49C2 00 00        MenuZPage DS W:1
0589 49C4                       EndR 
0590 49C4                        
0591 49C4              ;===========================================================================
0592 49C4              ;
0593 49C4              ; SaveAllCache's
0594 49C4              ;
0595 49C4              ; This routine will save the handle to each of the menu caches that are current
0596 49C4              ; this routine should be called before any routine that disposes of menu cache
0597 49C4              ;
0598 49C4              ; The menu mgr's direct page should be set going into this routine
0599 49C4              ;
0600 49C4              ;============================================================================
0601 49C4              SaveAllCache proc 
0602 49C4                       With CacheFixData 
0603 49C4
0604 49C4 8B                    phb   
0605 49C5 4B                    phk                            ; change to our databank...
0606 49C6 AB                    plb   
0607 49C7 9C 7E 4C              stz   NumCache                 ; start with no cache allocated
0608 49CA 7B                    tdc                            ; save the menu mgr direct page
0609 49CB 8D C2 4C              sta   MenuZPage
0610 49CE
0611 49CE A0 02 00              ldy   #2                       ; properly deref the menubar handle
0612 49D1 B7 18                 lda   [<barHand],y
0613 49D3 85 16                 sta   <barPtr+2
0614 49D5 A7 18                 lda   [<barHand]
0615 49D7 85 14                 sta   <barPtr
0616 49D9
0617 49D9 4B F4 E3 4C           ROMCall getmfirst              ; get the first menu handle
0618 49E4 F0 38                 beq   @done
0619 49E6
0620 49E6              @loop     
0621 49E6 AD 7E 4C              lda   NumCache
0622 49E9 0A                    asl   a
0623 49EA 0A                    asl   a
0624 49EB AA                    tax   
0625 49EC
0626 49EC A0 0A 00              ldy   #MenuFlag                ; see if this menu is cached
0627 49EF B7 1C                 lda   [<menuptr],y
0628 49F1 29 08 00              and   #M_Cache
0629 49F4 F0 12                 beq   @notCache
0630 49F6
0631 49F6 A0 14 00              ldy   #MenuCache               ; if it is, get the cache handle and
0632 49F9 B7 1C                 lda   [<menuPtr],y             ; save it for when the call is over
0633 49FB 9D 80 4C              sta   localCache,x
0634 49FE
0635 49FE A0 16 00              ldy   #MenuCache+2
0636 4A01 B7 1C                 lda   [<menuPtr],y
0637 4A03 9D 82 4C              sta   localCache+2,x
0638 4A06
0639 4A06 80 06                 bra   @cont
0640 4A08
0641 4A08 9E 80 4C     @NotCache stz   localCache,x            ; no cache , store zero's into our temp
0642 4A0B 9E 82 4C              stz   localcache+2,x
0643 4A0E              @cont     
0644 4A0E
0645 4A0E EE 7E 4C              inc   NumCache                 ; bump the menu count
0646 4A11 4B F4 1B 4D           ROMCall next_menu              ; see if there are any more
0647 4A1C D0 C8                 bne   @Loop                    ; yes, save its handle
0648 4A1E              @Done     
0649 4A1E AB                    plb                            ; now get out...
0650 4A1F 60                    rts   
0651 4A20                       endP 
0652 4A20
0653 4A20              ;===========================================================================
0654 4A20              ;
0655 4A20              ; DisposeCache's
0656 4A20              ;
0657 4A20              ; This routine will save the handle to each of the menu caches that are current
0658 4A20              ; this routine should be called before any routine that disposes of menu cache
0659 4A20              ;
0660 4A20              ; The menu mgr's direct page should be set going into this routine
0661 4A20              ;
0662 4A20              ;============================================================================
0663 4A20              DisposeCache proc 
0664 4A20                       With CacheFixData 
0665 4A20              ; flag in <Y> says whether to purge all or not
0666 4A20 0B                    phd   
0667 4A21 AF C2 4C 02           lda   >MenuZPage               ; switch to the menu mgr zpage
0668 4A25 5B                    tcd   
0669 4A26
0670 4A26 8B                    phb   
0671 4A27 4B                    phk                            ; change to our databank...
0672 4A28 AB                    plb   
0673 4A29
0674 4A29 9C C0 4C              stz   CountTemp
0675 4A2C
0676 4A2C AD 7E 4C              lda   NumCache                 ; start with no cache allocated
0677 4A2F F0 7F                 beq   @done                    ; if this is zero, purge none...
0678 4A31
0679 4A31 8D C2 4C              sta   NumInList
0680 4A34
0681 4A34 C0 FF FF              cpy   #$FFFF                   ; test the input flag to see if this call
0682 4A37 D0 03                 bne   @notAll                  ; should have purged all the caches
0683 4A39 82 4B 00              brl   @purgeAll                ; if so, just do it.
0684 4A3C              @notAll   
0685 4A3C A0 02 00              ldy   #2
0686 4A3F B7 18                 lda   [<barHand],y
0687 4A41 85 16                 sta   <barPtr+2
0688 4A43 A7 18                 lda   [<barHand]
0689 4A45 85 14                 sta   <barPtr
0690 4A47
0691 4A47 4B F4 51 4D           ROMCall getmfirst              ; get the first menu handle
0692 4A52 F0 33                 beq   @purgeAll                ; if this is zero, then purge all
0693 4A54              @loop     
0694 4A54 AD C0 4C              lda   CountTemp
0695 4A57 0A                    asl   a
0696 4A58 0A                    asl   a
0697 4A59 AA                    tax   
0698 4A5A
0699 4A5A A0 15 00              ldy   #menuCache+1             ; see if the current menu is the same
0700 4A5D B7 1C                 lda   [<menuPtr],y             ; by comparing these two bytes...
0701 4A5F DD 81 4C              cmp   localCache+1,x
0702 4A62 D0 0E                 bne   @Next                    ; if not the same leave us alone
0703 4A64 88                    dey   
0704 4A65 B7 1C                 lda   [<menuPtr],y
0705 4A67 DD 80 4C              cmp   localCache,x
0706 4A6A D0 06                 bne   @next
0707 4A6C
0708 4A6C 9E 80 4C              stz   localCache,x             ; if the same don't dispose of this one
0709 4A6F 9E 82 4C              stz   LocalCache+2,x
0710 4A72              @Next     
0711 4A72 EE C0 4C              inc   CountTemp                ;
0712 4A75 CE 7E 4C              dec   NumCache                 ; bump the menu count
0713 4A78 F0 0D                 beq   @purgeAll                ; when done, exit...
0714 4A7A 4B F4 84 4D           ROMCall next_menu              ; see if there are any more
0715 4A85 D0 CD                 bne   @Loop                    ; yes, save its handle
0716 4A87              @purgeAll  
0717 4A87 9C 7E 4C              stz   NumCache
0718 4A8A
0719 4A8A AD 7E 4C     @purgeLoop lda   NumCache
0720 4A8D 0A                    asl   a
0721 4A8E 0A                    asl   a
0722 4A8F AA                    tax   
0723 4A90 BD 81 4C              lda   localCache+1,x
0724 4A93 F0 0F                 beq   @nextPurge
0725 4A95 BD 82 4C              lda   localCache+2,x
0726 4A98 48                    pha   
0727 4A99 BD 80 4C              lda   LocalCache,x
0728 4A9C 48                    pha   
0729 4A9D A2 02 10 22           _DisposeHandle 
0730 4AA4              @NextPurge  
0731 4AA4 AD 7E 4C              lda   NumCache
0732 4AA7 1A                    inc   a
0733 4AA8 8D 7E 4C              sta   NumCache
0734 4AAB CD C2 4C              cmp   NumInList
0735 4AAE 90 DA                 blt   @purgeLoop
0736 4AB0
0737 4AB0              @Done     
0738 4AB0 AB                    plb                            ; now get out...
0739 4AB1 2B                    pld   
0740 4AB2
0741 4AB2 60                    rts   
0742 4AB3                       endP 
0743 4AB3
0744 4AB3              ;
0745 4AB3              ;
0746 4AB3              localsetCurrentBar PROC 
0747 4AB3
0748 4AB3 A3 0C                 lda   input+2,s                Get menu bar pointer.
0749 4AB5 85 18                 sta   <barhand
0750 4AB7 A3 0E                 lda   input+4,s
0751 4AB9 85 1A                 sta   <barhand+2
0752 4ABB 05 18                 ora   <barhand                 Menu bar passed?
0753 4ABD D0 08                 bne   exit
0754 4ABF
0755 4ABF                       ENTRY sys_current 
0756 4ABF              sys_current                             ;
0757 4ABF A5 08                 lda   <sysmenu                 Caller wants the system bar.
0758 4AC1 85 18                 sta   <barhand
0759 4AC3 A5 0A                 lda   <sysmenu+2
0760 4AC5 85 1A                 sta   <barhand+2
0761 4AC7
0762 4AC7              exit      
0763 4AC7 60                    rts   
0764 4AC8
0765 4AC8
0766 4AC8                       ENDP 
0767 4AC8
0768 4AC8              localStartup proc 
0769 4AC8 22 64 00 E1           jsl   IncBusyFlg
0770 4ACC 7A                    ply   
0771 4ACD 0B                    phd                            ; save d-reg
0772 4ACE 8B                    phb                            ; save b-reg
0773 4ACF F4 FD FD              pea   $FDFD                    ; set dbr to same as in ROM
0774 4AD2 AB                    plb   
0775 4AD3 AB                    plb   
0776 4AD4 5B                    tcd                            ; set d-reg
0777 4AD5 5A                    phy   
0778 4AD6 60                    rts   
0779 4AD7                       endP 
0780 4AD7
0781 4AD7
0782 4AD7              ;===========================================================================
0783 4AD7              ;
0784 4AD7              ;   MenuStartUp
0785 4AD7              ;
0786 4AD7              ; Patch to set the item blink from battery-RAM.
0787 4AD7              ; 17-Feb-91 DAL
0788 4AD7              ;===========================================================================
0789 4AD7              MenuStartUp proc 
0790 4AD7
0791 4AD7 AA                    tax   
0792 4AD8 A3 09                 lda   9,s
0793 4ADA 48                    pha   
0794 4ADB A3 09                 lda   9,s
0795 4ADD 48                    pha   
0796 4ADE 8A                    txa   
0797 4ADF 22 08 4E 02           jsl   @toROM
0798 4AE3 AA                    tax                            ;error code
0799 4AE4 B0 1B                 bcs   @exit
0800 4AE6
0801 4AE6 48                    pha   
0802 4AE7 F4 5E 00              pea   $5E                      ;bram location
0803 4AEA A2 03 0C 22           _ReadBParam 
0804 4AF1 68                    pla   
0805 4AF2 4A                    lsr   a
0806 4AF3 4A                    lsr   a
0807 4AF4 4A                    lsr   a                        ;got bits 3-4 into 0-1
0808 4AF5 29 03 00              and   #3
0809 4AF8 48                    pha   
0810 4AF9 A2 0F 28 22           _SetMItemBlink 
0811 4B00 AA                    tax                            ;error code
0812 4B01 A0 04 00     @exit    ldy   #4                       ;clean up 4 bytes
0813 4B04 5C 84 01 E1           jml   $e10184                  ;ToStrip
0814 4B08
0815 4B08 22 67 56 FD  @toROM   jsl   $fd5667                  ;ROM 3 original MenuStartUp entry
0816 4B0C 6B                    rtl   
0817 4B0D
0818 4B0D                       endp 
0819 4B0D
0820 4B0D
0821 4B0D              ;===========================================================================
0822 4B0D              ;
0823 4B0D              ;   MenuShutdown
0824 4B0D              ;
0825 4B0D              ; Patch to clean up purged handles
0826 4B0D              ; 5/25/89 Mensch and Harry Yee
0827 4B0D              ;===========================================================================
0828 4B0D              MenuShutdown proc 
0829 4B0D                       With CacheFixData 
0830 4B0D              MenuShutDownEntry equ   $FD5793
0831 4B0D              MenuShutDownEntry3 equ   $FD57c1
0832 4B0D
0833 4B0D C9 00 00              cmp   #0
0834 4B10 D0 02                 bne   @Continue
0835 4B12 18                    clc   
0836 4B13 6B                    rtl   
0837 4B14              @Continue  
0838 4B14 20 C8 4D              jsr   localStartup
0839 4B17 A5 09                 lda   <sysMenu+1
0840 4B19 F0 10                 beq   NoBar
0841 4B1B
0842 4B1B 20 BF 4D              jsr   sys_current
0843 4B1E 20 C4 4C              jsr   saveAllCache
0844 4B21
0845 4B21 A0 FF FF              ldy   #$FFFF
0846 4B24 20 20 4D              jsr   DisposeCache
0847 4B27
0848 4B27 5C 93 57 FD           jml   MenuShutDownEntry
0849 4B2B
0850 4B2B 5C C1 57 FD  NoBar    jml   MenuShutdownEntry3
0851 4B2F                       endp 
0852 4B2F
0853 4B2F              ;===========================================================================
0854 4B2F              ;
0855 4B2F              ;   MenuNewRes
0856 4B2F              ;
0857 4B2F              ; Patch to clean up purged handles
0858 4B2F              ; 5/25/89 Mensch and Harry Yee
0859 4B2F              ;===========================================================================
0860 4B2F              MenuNewRes proc 
0861 4B2F                       With CacheFixData 
0862 4B2F
0863 4B2F 20 C8 4D              jsr   localStartup
0864 4B32 A5 09                 lda   <sysMenu+1
0865 4B34 F0 11                 beq   NoBar
0866 4B36
0867 4B36 20 BF 4D              jsr   sys_current
0868 4B39 20 C4 4C              jsr   saveAllCache
0869 4B3C
0870 4B3C 7B                    tdc   
0871 4B3D 22 4B 4E 02           jsl   MenuNewResGlue
0872 4B41
0873 4B41 A0 FF FF              ldy   #$FFFF
0874 4B44 20 20 4D              jsr   DisposeCache
0875 4B47 5C A3 8F FD  NoBar    jml   pop0Bytes
0876 4B4B
0877 4B4B 22 EB 57 FD  MenuNewResGlue jsl   ROMMenuNewRes
0878 4B4F 6B                    rtl   
0879 4B50                       endp 
0880 4B50
0881 4B50
0882 4B50              ;===========================================================================
0883 4B50              ;
0884 4B50              ;                   myFreeCache
0885 4B50              ;
0886 4B50              ;===========================================================================
0887 4B50              myFreeCache PROC 
0888 4B50
0889 4B50 A0 0A 00              ldy   #MenuFlag                Check if there can be a cahce.
0890 4B53 B7 1C                 lda   [<menuptr],y
0891 4B55 29 08 00              and   #M_CACHE
0892 4B58 F0 1F                 beq   exit
0893 4B5A
0894 4B5A A0 15 00              ldy   #MenuCache+1             Is there a cache?
0895 4B5D B7 1C                 lda   [<menuptr],y
0896 4B5F F0 18                 beq   exit
0897 4B61
0898 4B61 C8                    iny   
0899 4B62 B7 1C                 lda   [<menuptr],y
0900 4B64 48                    pha                            Put handle of cache to be disposed of on 
0901 4B65 88                    dey                            the stack
0902 4B66 88                    dey   
0903 4B67 B7 1C                 lda   [<menuptr],y
0904 4B69 48                    pha   
0905 4B6A
0906 4B6A A0 15 00              ldy   #MenuCache+1
0907 4B6D A9 00 00              lda   #0                       Mark cache as gone.
0908 4B70 97 1C                 sta   [<menuptr],y
0909 4B72
0910 4B72 A2 02 10 22           _DisposeHandle Get rid of cache
0911 4B79
0912 4B79 60           exit     rts   
0913 4B7A
0914 4B7A                       ENDP 
0915 4B7A
0916 4B7A              ;===========================================================================
0917 4B7A              ;
0918 4B7A              ;                   myEveryCacheFree
0919 4B7A              ;
0920 4B7A              ;===========================================================================
0921 4B7A              myEveryCacheFree PROC 
0922 4B7A
0923 4B7A 4B F4 84 4E           ROMCALL getmfirst Start with first menu.
0924 4B85 F0 10                 beq   exit                     Are there any menus?
0925 4B87
0926 4B87 20 50 4E     lop1     jsr   myFreeCache              Mark cache bad if menu has a cache.
0927 4B8A
0928 4B8A 4B F4 94 4E           ROMCALL next_menu Try next menu
0929 4B95 D0 F0                 bne   lop1
0930 4B97
0931 4B97 60           exit     rts   
0932 4B98
0933 4B98                       ENDP 
0934 4B98
0935 4B98              ;===========================================================================
0936 4B98              ;
0937 4B98              ;   DeleteMenu
0938 4B98              ;
0939 4B98              ; Patch to clean up purged handles
0940 4B98              ; 5/25/89 Mensch and Harry Yee
0941 4B98              ;===========================================================================
0942 4B98              DeleteMenu PROC 
0943 4B98
0944 4B98              menunum  equ   input
0945 4B98
0946 4B98 20 C8 4D              jsr   localStartup
0947 4B9B 4B F4 A5 4E           ROMCALL lockMenuBar 
0948 4BA6 F0 5C                 beq   exit2
0949 4BA8              ;
0950 4BA8              ; --- Take menu out of menu list ---------------------------------
0951 4BA8              ;
0952 4BA8 A3 0A                 lda   menunum,s                ID to match.
0953 4BAA 4B F4 B4 4E           ROMCALL getmptr Find the menu.
0954 4BB5 F0 42                 beq   exit
0955 4BB7
0956 4BB7 20 50 4E              jsr   myFreeCache              Release cache that may be allocated for this menu.
0957 4BBA
0958 4BBA A0 04 00              ldy   #4
0959 4BBD B7 20                 lda   [<menuhand],y
0960 4BBF 29 FF 7F              and   #$7FFF                   Unlock the handle of menu to be removed.
0961 4BC2 97 20                 sta   [<menuhand],y
0962 4BC4
0963 4BC4 4B F4 CE 4E  lop2     ROMCALL next_menu 
0964 4BCF
0965 4BCF A5 36                 lda   <menu_cnt
0966 4BD1 38                    sec   
0967 4BD2 E9 08 00              sbc   #8
0968 4BD5 A8                    tay   
0969 4BD6
0970 4BD6 A5 20                 lda   <menuhand
0971 4BD8 97 14                 sta   [<barptr],y
0972 4BDA A5 22                 lda   <menuhand+2
0973 4BDC C8                    iny   
0974 4BDD C8                    iny   
0975 4BDE 97 14                 sta   [<barptr],y
0976 4BE0
0977 4BE0 05 20                 ora   <menuhand                Any more menu's?
0978 4BE2 D0 E0                 bne   lop2
0979 4BE4
0980 4BE4              ;
0981 4BE4              ; --- Shrink menu record for deleted item -------------------------------------
0982 4BE4              ;
0983 4BE4 A6 1A                 ldx   <barhand+2               Pass menu bar's handle
0984 4BE6 A5 18                 lda   <barhand
0985 4BE8 A0 FC FF              ldy   #$FFFC                   Number of bytes to decrease.
0986 4BEB 4B F4 F5 4E           ROMCALL growBlock Shrink the menu record.
0987 4BF6
0988 4BF6 20 7A 4E              jsr   myEveryCacheFree         Menus may now be in different order.
0989 4BF9
0990 4BF9 4B F4 03 4F  exit     ROMCALL unlockMenuBar Leave menu bar & menus unlocked.
0991 4C04
0992 4C04 5C AB 8F FD  exit2    jml   pop2bytes
0993 4C08
0994 4C08                       ENDP 
0995 4C08
0996 4C08              ;===========================================================================
0997 4C08              ;
0998 4C08              ;   DeleteMItem
0999 4C08              ;
1000 4C08              ; Patch to clean up purged handles
1001 4C08              ; 5/25/89 Mensch and Harry Yee
1002 4C08              ;===========================================================================
1003 4C08              DeleteMItem proc 
1004 4C08                       With CacheFixData 
1005 4C08
1006 4C08 20 C8 4D              jsr   localStartup
1007 4C0B A5 19                 lda   <barHand+1
1008 4C0D F0 15                 beq   NoBar
1009 4C0F
1010 4C0F 20 C4 4C              jsr   saveAllCache
1011 4C12
1012 4C12 3B                    tsc   
1013 4C13 5B                    tcd   
1014 4C14 D4 0A                 pei   Input
1015 4C16 AF C2 4C 02           lda   >MenuZPage
1016 4C1A 22 28 4F 02           jsl   DeleteMItemGlue
1017 4C1E
1018 4C1E A0 00 00              ldy   #$0000
1019 4C21 20 20 4D              jsr   DisposeCache
1020 4C24 5C AB 8F FD  NoBar    jml   pop2Bytes
1021 4C28
1022 4C28 22 4F 76 FD  DeleteMItemGlue jsl   ROMDeleteMItem
1023 4C2C 6B                    rtl   
1024 4C2D                       endp 
1025 4C2D
1026 4C2D              ;===========================================================================
1027 4C2D              ;
1028 4C2D              ;   InsertMItem
1029 4C2D              ;
1030 4C2D              ; Patch to clean up purged handles
1031 4C2D              ; 5/25/89 Mensch and Harry Yee
1032 4C2D              ;===========================================================================
1033 4C2D              InsertMItem proc 
1034 4C2D                       With CacheFixData 
1035 4C2D
1036 4C2D 20 C8 4D              jsr   localStartup
1037 4C30 A5 19                 lda   <barHand+1
1038 4C32 F0 1B                 beq   NoBar
1039 4C34
1040 4C34 20 C4 4C              jsr   saveAllCache
1041 4C37
1042 4C37 3B                    tsc   
1043 4C38 5B                    tcd   
1044 4C39 D4 10                 pei   Input+6
1045 4C3B D4 0E                 pei   Input+4
1046 4C3D D4 0C                 pei   Input+2
1047 4C3F D4 0A                 pei   Input
1048 4C41 AF C2 4C 02           lda   >MenuZPage
1049 4C45 22 53 4F 02           jsl   InsertMItemGlue
1050 4C49
1051 4C49 A0 00 00              ldy   #$0000
1052 4C4C 20 20 4D              jsr   DisposeCache
1053 4C4F 5C C3 8F FD  NoBar    jml   pop8Bytes
1054 4C53
1055 4C53 22 64 75 FD  InsertMItemGlue jsl   ROMInsertMItem
1056 4C57 6B                    rtl   
1057 4C58                       endp 
1058 4C58
1059 4C58
1060 4C58              ;===========================================================================
1061 4C58              ;
1062 4C58              ;   InsertMItem2
1063 4C58              ;
1064 4C58              ; Patch to clean up purged handles
1065 4C58              ; 5/25/89 Mensch and Harry Yee
1066 4C58              ;===========================================================================
1067 4C58              InsertMItem2 proc 
1068 4C58                       With CacheFixData 
1069 4C58
1070 4C58 20 C8 4D              jsr   localStartup
1071 4C5B A5 19                 lda   <barHand+1
1072 4C5D F0 1D                 beq   NoBar
1073 4C5F
1074 4C5F 20 C4 4C              jsr   saveAllCache
1075 4C62
1076 4C62 3B                    tsc   
1077 4C63 5B                    tcd   
1078 4C64 D4 12                 pei   Input+8
1079 4C66 D4 10                 pei   Input+6
1080 4C68 D4 0E                 pei   Input+4
1081 4C6A D4 0C                 pei   Input+2
1082 4C6C D4 0A                 pei   Input
1083 4C6E AF C2 4C 02           lda   >MenuZPage
1084 4C72 22 80 4F 02           jsl   InsertMItem2Glue
1085 4C76
1086 4C76 A0 00 00              ldy   #$0000
1087 4C79 20 20 4D              jsr   DisposeCache
1088 4C7C 5C CB 8F FD  NoBar    jml   popABytes
1089 4C80
1090 4C80 22 3A 75 FD  InsertMItem2Glue jsl   ROMInsertMItem2
1091 4C84 6B                    rtl   
1092 4C85                       endp 
1093 4C85
1094 4C85              ;=======================================================================
1095 4C85              ;
1096 4C85              ;                   GetStruct
1097 4C85              ;
1098 4C85              ;  IN: <itemptr pts to a valid item record
1099 4C85              ; OUT: <temptr contains data we're looking for
1100 4C85              ;
1101 4C85              ;=======================================================================
1102 4C85              GetStruct PROC 
1103 4C85
1104 4C85 A0 08 00              ldy   #ItemName
1105 4C88 B7 24                 lda   [<itemptr],y
1106 4C8A 85 28                 sta   <temptr
1107 4C8C A0 0A 00              ldy   #ItemName+2
1108 4C8F B7 24                 lda   [<itemptr],y
1109 4C91 85 2A                 sta   <temptr+2
1110 4C93
1111 4C93 A0 06 00              ldy   #ItemFlag
1112 4C96 B7 24                 lda   [<itemptr],y
1113 4C98 29 00 03              and   #$0300                   Bits 8 and 9 tell us how structure is referenced.
1114 4C9B D0 03                 bne   @ResOrHdl                If non-zero then structure is referenced as a hdl or resource
1115 4C9D 82 97 00              brl   doPointer
1116 4CA0 C9 00 01     @ResOrHdl cmp   #I_STRUCTisHANDLE
1117 4CA3 D0 03                 bne   @doRes
1118 4CA5 82 83 00              brl   doHandle
1119 4CA8 A0 28 80     @doRes   ldy   #rMyItemStruct
1120 4CAB 82 6A 00              brl   doResource
1121 4CAE
1122 4CAE
1123 4CAE              ;=======================================================================
1124 4CAE              ;
1125 4CAE              ;                   getrItemName
1126 4CAE              ; 
1127 4CAE              ;  IN:  <itemptr contains ptr current item record in menu 
1128 4CAE              ; OUT:  a = low word of ptr to item name, x = high word of ptr
1129 4CAE              ;
1130 4CAE              ;=======================================================================
1131 4CAE                       ENTRY getrItemName 
1132 4CAE              getrItemName  
1133 4CAE A0 06 00              ldy   #ItemFlag                check if there is an additional structure associated with item
1134 4CB1 B7 24                 lda   [<itemptr],y
1135 4CB3 29 00 04              and   #I_NEWSTRUCTURE
1136 4CB6 F0 14                 beq   OldWay                   if not then field "ItemName" does indeed contain the item's name
1137 4CB8
1138 4CB8 20 85 4F              jsr   GetStruct                Get the ptr to the new structure that now contains the
1139 4CBB A0 02 00              ldy   #ItemName2               item's name.
1140 4CBE B7 28                 lda   [<temptr],y
1141 4CC0 AA                    tax   
1142 4CC1 A0 04 00              ldy   #ItemName2+2
1143 4CC4 B7 28                 lda   [<temptr],y
1144 4CC6 85 2A                 sta   <temptr+2
1145 4CC8 86 28                 stx   <temptr
1146 4CCA 80 0E                 bra   GetName                  We now have the reference to the item's name in <temptr.
1147 4CCC
1148 4CCC A0 08 00     OldWay   ldy   #ItemName
1149 4CCF B7 24                 lda   [<itemptr],y
1150 4CD1 AA                    tax   
1151 4CD2 C8                    iny   
1152 4CD3 C8                    iny   
1153 4CD4 B7 24                 lda   [<itemptr],y
1154 4CD6 85 2A                 sta   <temptr+2
1155 4CD8 86 28                 stx   <temptr
1156 4CDA              GetName   
1157 4CDA A0 06 00              ldy   #ItemFlag
1158 4CDD B7 24                 lda   [<itemptr],y
1159 4CDF 29 00 C0              and   #FIRST_TWO_BITS
1160 4CE2 D0 03                 bne   @1
1161 4CE4 82 50 00              brl   doPointer
1162 4CE7 C9 00 40     @1       cmp   #HANDLE_REF
1163 4CEA D0 03                 bne   @2
1164 4CEC 82 3C 00              brl   doHandle
1165 4CEF A0 06 80     @2       ldy   #rPString                ;was rString 17-Sep-90 DAL
1166 4CF2 82 23 00              brl   doResource
1167 4CF5
1168 4CF5
1169 4CF5              ;=======================================================================
1170 4CF5              ;
1171 4CF5              ;                   getrItemIcon
1172 4CF5              ; 
1173 4CF5              ;  IN:  <itemptr contains ptr current item record in menu 
1174 4CF5              ;       <temptr contains ptr to item's new structure
1175 4CF5              ; OUT:  a = low word of ptr to item icon, x = high word of ptr
1176 4CF5              ;       a & x = 0 if there is no icon associated with the icon
1177 4CF5              ;
1178 4CF5              ;=======================================================================
1179 4CF5                       ENTRY getrItemIcon 
1180 4CF5              getrItemIcon  
1181 4CF5 A0 00 00              ldy   #ItemFlag2               ; Extract flag from new structure that will tell us
1182 4CF8 B7 28                 lda   [<temptr],y              ; how the icon will be referenced, i.e. ptr, hdl, resource
1183 4CFA 48                    pha                            ; Save flag from structure on the stack for now.
1184 4CFB
1185 4CFB A0 06 00              ldy   #ItemIcon                ; Now extract the icon ref from this structure and put
1186 4CFE B7 28                 lda   [<temptr],y              ; reference in <temptr.
1187 4D00 AA                    tax   
1188 4D01 A0 08 00              ldy   #ItemIcon+2
1189 4D04 B7 28                 lda   [<temptr],y
1190 4D06 85 2A                 sta   <temptr+2
1191 4D08 86 28                 stx   <temptr
1192 4D0A
1193 4D0A 68                    pla                            ; check flag from struct to see how icon will be referenced
1194 4D0B 29 03 00              and   #$0003                   ; Bits 8 and 9 tells us how the icon data will be referenced.
1195 4D0E F0 27                 beq   doPointer                ; Zero means its a ptr to the icon data.
1196 4D10 C9 01 00     @ResORHdl cmp   #$0001
1197 4D13 F0 16                 beq   doHandle                 ; Is the icon ref a handle?
1198 4D15 A0 01 80     @IconRefIsResource ldy   #rIcon
1199 4D18 A5 28        doResource lda   <temptr                ; resource ID
1200 4D1A A6 2A                 ldx   <temptr+2
1201 4D1C 4B F4 26 50           ROMCALL LoadnRelease           ; loads resource and releases it, then returns handle
1202 4D27 85 28                 sta   <temptr
1203 4D29 86 2A                 stx   <temptr+2
1204 4D2B
1205 4D2B A0 02 00     doHandle ldy   #2
1206 4D2E B7 28                 lda   [<temptr],y
1207 4D30 AA                    tax   
1208 4D31 A7 28                 lda   [<temptr]
1209 4D33 85 28                 sta   <temptr
1210 4D35 86 2A                 stx   <temptr+2
1211 4D37
1212 4D37 A5 28        doPointer lda   <temptr                 ; low word of ptr to menu title/item name/icon ref
1213 4D39 A6 2A                 ldx   <temptr+2                ; high word of ptr to menu title/item name/icon ref
1214 4D3B
1215 4D3B 60                    rts   
1216 4D3C
1217 4D3C
1218 4D3C                       ENDP 
1219 4D3C
1220 4D3C
1221 4D3C              ;=======================================================================
1222 4D3C              ;
1223 4D3C              ;                   getistrg
1224 4D3C              ;
1225 4D3C              ;=======================================================================
1226 4D3C              getistrg PROC 
1227 4D3C
1228 4D3C 20 AE 4F              jsr   getrItemName             Put item's string pointer in 'strg_ptr'
1229 4D3F 85 64                 sta   <strg_ptr
1230 4D41 86 66                 stx   <strg_ptr+2
1231 4D43
1232 4D43 60                    rts   
1233 4D44
1234 4D44                       ENDP 
1235 4D44
1236 4D44
1237 4D44              ;===========================================================================
1238 4D44              ;
1239 4D44              ;                   GetIconInfo
1240 4D44              ;
1241 4D44              ;  IN: <itemptr contains ptr to current item in menu 
1242 4D44              ; OUT: a-reg contains width of icon, x-reg contains height of icon
1243 4D44              ;
1244 4D44              ;===========================================================================
1245 4D44              getIconInfo PROC 
1246 4D44
1247 4D44
1248 4D44              OrigD    equ   1
1249 4D44              MyIconRect equ   OrigD+2
1250 4D44
1251 4D44 A0 06 00              ldy   #ItemFlag                ; first check to see if there is an icon
1252 4D47 B7 24                 lda   [<itemptr],y             ; associated with this item
1253 4D49 29 00 04              and   #I_NEWSTRUCTURE
1254 4D4C F0 0A                 beq   NoIconFound
1255 4D4E
1256 4D4E 20 85 4F              jsr   GetStruct                ; then check if this new structure contains
1257 4D51 A0 00 00              ldy   #ItemFlag2               ; an icon field
1258 4D54 B7 28                 lda   [<temptr],y
1259 4D56 30 0B                 bmi   GotIcon
1260 4D58
1261 4D58 A9 00 00     NoIconFound lda   #0                    ; there's no icon so zero the appropriate output values
1262 4D5B A2 00 00              ldx   #0
1263 4D5E A0 00 00              ldy   #0
1264 4D61 80 1F                 bra   OttaHere
1265 4D63              GotIcon   
1266 4D63 20 F5 4F              jsr   getrItemIcon             ; get the icon's ref
1267 4D66
1268 4D66 DA                    phx                            ; put it on the stack so we can reference it easier
1269 4D67 48                    pha   
1270 4D68 0B                    phd                            ; save current direct page register
1271 4D69 3B                    tsc                            ; turn stack into direct page
1272 4D6A 5B                    tcd   
1273 4D6B
1274 4D6B A0 04 00              ldy   #oQDIconHeight
1275 4D6E B7 03                 lda   [<MyIconRect],y
1276 4D70 AA                    tax                            ; x-reg contains the icon's height
1277 4D71 A0 06 00              ldy   #oQDIconWidth
1278 4D74 B7 03                 lda   [<MyIconRect],y          ; a-reg contains the icon's width
1279 4D76 2B                    pld                            ; restore original direct page register
1280 4D77 7A                    ply                            ; clean up stack
1281 4D78 7A                    ply   
1282 4D79
1283 4D79 A8                    tay   
1284 4D7A A5 46                 lda   <ScreenMode
1285 4D7C F0 03                 beq   @In320Mode
1286 4D7E 98                    tya   
1287 4D7F 0A                    asl   a
1288 4D80 A8                    tay   
1289 4D81 98           @In320Mode tya   
1290 4D82
1291 4D82 60           OttaHere rts   
1292 4D83
1293 4D83                       ENDP 
1294 4D83
1295 4D83
1296 4D83              ;===========================================================================
1297 4D83              ;
1298 4D83              ; mSizeDispatch
1299 4D83              ;
1300 4D83              ;===========================================================================
1301 4D83              mSizeDispatch PROC 
1302 4D83
1303 4D83 A0 07 00              ldy   #MenuProc+1
1304 4D86 B7 1C                 lda   [<menuptr],y
1305 4D88 F0 03                 beq   notCustom
1306 4D8A 82 8D 00              brl   Custom
1307 4D8D
1308 4D8D 64 10        notCustom stz   <rect+y2                Height accumulator.
1309 4D8F 64 12                 stz   <rect+x2                 Width accumulator.
1310 4D91
1311 4D91              ; --- Set every item's height, max width, and menu's height -----
1312 4D91              ;
1313 4D91 4B F4 9B 50           ROMCALL getifirst Get pointer to first item.
1314 4D9C F0 7B                 beq   exit                     Are there any items?
1315 4D9E
1316 4D9E              ; ------- Find item's width --------------------
1317 4D9E              ;
1318 4D9E 4B F4 A8 50  lop1     ROMCALL FixTextFace  
1319 4DA9
1320 4DA9 48                    pha                            Space for result.
1321 4DAA 20 3C 50              jsr   getistrg                 Get pointer to item's string.
1322 4DAD DA                    phx                            Pass high word.
1323 4DAE 48                    pha                            Pass low word.
1324 4DAF A2 04 A9 22           _StringWidth Get string's width.
1325 4DB6
1326 4DB6 20 44 50              jsr   GetIconInfo              a-reg contains width of icon
1327 4DB9 AA                    tax   
1328 4DBA F0 08                 beq   @NoIcon                  If a-reg is zero then there is no icon
1329 4DBC 18                    clc   
1330 4DBD 63 01                 adc   1,s                      Add width of item name and icon width.
1331 4DBF 69 05 00              adc   #5                       Add in some additional slop for spacing between icon.
1332 4DC2 83 01                 sta   1,s                      Put result back on the stack.
1333 4DC4              @NoIcon   
1334 4DC4 A5 62                 lda   <text_width              Add room for the check mark.
1335 4DC6 18                    clc   
1336 4DC7 65 62                 adc   <text_width
1337 4DC9 65 62                 adc   <text_width
1338 4DCB AA                    tax   
1339 4DCC A0 02 00              ldy   #ItemChar
1340 4DCF B7 24                 lda   [<itemptr],y
1341 4DD1 29 FF 00              and   #$00FF
1342 4DD4 F0 10                 beq   ok34
1343 4DD6 A5 62                 lda   <text_width
1344 4DD8 18                    clc   Now add space for the keyboard equivalent, the apple key 
1345 4DD9 6A                    ror   a                        and a chacracter, plus one extra for slop
1346 4DDA 18                    clc   
1347 4DDB 65 62                 adc   <text_width
1348 4DDD 65 62                 adc   <text_width              1 1/2 for check mark, 2 for cmd-key-equiv,2 for space
1349 4DDF 65 62                 adc   <text_width
1350 4DE1 65 62                 adc   <text_width
1351 4DE3 65 62                 adc   <text_width
1352 4DE5 AA                    tax   
1353 4DE6 8A           ok34     txa   
1354 4DE7 18                    clc   
1355 4DE8 63 01                 adc   1,s
1356 4DEA FA                    plx                            Pull in x just to fix stack, a = value.
1357 4DEB
1358 4DEB              ; ------- Keep the width of the widest item ----------------
1359 4DEB              ;
1360 4DEB C5 12                 cmp   <rect+x2                 Is this the longest item?
1361 4DED 90 02                 bcc   do_height
1362 4DEF 85 12                 sta   <rect+x2                 Save the longest width.
1363 4DF1
1364 4DF1              ; ------- Accumulate item height ----------------------------
1365 4DF1              ;
1366 4DF1 4B F4 FB 50  do_height ROMCALL getitemh Get the item's height.
1367 4DFC 18                    clc                            Keep a running height total.
1368 4DFD 65 10                 adc   <rect+y2
1369 4DFF 85 10                 sta   <rect+y2
1370 4E01
1371 4E01              ; ------- Next item --------------------------------------------
1372 4E01              ;
1373 4E01 4B F4 0B 51           ROMCALL next_item 
1374 4E0C D0 90                 bne   lop1                     Any more items?
1375 4E0E
1376 4E0E 4B F4 18 51           ROMCALL intoSizeMenu 
1377 4E19
1378 4E19 60           exit     rts   
1379 4E1A
1380 4E1A A2 02 00     custom   ldx   #mSize
1381 4E1D 4B F4 27 51           ROMCALL Dispatch 
1382 4E28
1383 4E28 60                    rts   
1384 4E29
1385 4E29                       ENDP 
1386 4E29
1387 4E29
1388 4E29              ;===========================================================================
1389 4E29              ;
1390 4E29              ;   CalcMenuSize
1391 4E29              ;
1392 4E29              ; Patch to clean up purged handles
1393 4E29              ; 5/25/89 Mensch and Harry Yee
1394 4E29              ;===========================================================================
1395 4E29              CalcMenuSize PROC 
1396 4E29
1397 4E29              menunum  equ   input
1398 4E29              height   equ   menunum+2
1399 4E29              theWidth equ   height+2
1400 4E29
1401 4E29 20 C8 4D              jsr   localStartup             set DB to $FD and switch in MenuMgr d-page
1402 4E2C 4B F4 36 51           ROMCALL lockMenuBar <barptr = (<barHand), bar & menus locked
1403 4E37 F0 51                 beq   exit2                    Is there a current menu bar?
1404 4E39
1405 4E39 4B F4 43 51           ROMCALL to_myport Switch to menu mgr's port
1406 4E44
1407 4E44 A3 0A                 lda   menunum,s                Get menu's ID.
1408 4E46 4B F4 50 51           ROMCALL getmptr Get ptr to menu record for this ID.
1409 4E51 F0 21                 beq   exit                     Was the menu found?
1410 4E53
1411 4E53 20 50 4E              jsr   myFreeCache              Free menu's cache since size maybe wrong.
1412 4E56
1413 4E56 A0 02 00              ldy   #MenuWidth               Set menu record with given parameters.
1414 4E59 A3 0E                 lda   theWidth,s
1415 4E5B 10 02                 bpl   ok1
1416 4E5D
1417 4E5D B7 1C                 lda   [<menuptr],y             Leave MenuWidth alone.
1418 4E5F 97 1C        ok1      sta   [<menuptr],y
1419 4E61 AA                    tax   
1420 4E62 C8                    iny   
1421 4E63 C8                    iny   
1422 4E64 A3 0C                 lda   height,s
1423 4E66 10 02                 bpl   ok2
1424 4E68
1425 4E68 B7 1C                 lda   [<menuptr],y             Leave MenuHeight alone.
1426 4E6A 97 1C        ok2      sta   [<menuptr],y
1427 4E6C F0 03                 beq   calc_size                Asking for default height?
1428 4E6E 8A                    txa   
1429 4E6F D0 03                 bne   exit                     Asking for default width?
1430 4E71              ;
1431 4E71              ; --- Compute width and height -------------------------------------------
1432 4E71              ;
1433 4E71 20 83 50     calc_size jsr   mSizeDispatch
1434 4E74
1435 4E74 4B F4 7E 51  exit     ROMCALL to_uport Restore original port.
1436 4E7F 4B F4 89 51           ROMCALL unlockMenuBar Leave menu bar & menus unlocked.
1437 4E8A
1438 4E8A 5C BB 8F FD  exit2    jml   pop6bytes
1439 4E8E
1440 4E8E                       ENDP 
1441 4E8E
1442 4E8E
1443 4E8E              ;===========================================================================
1444 4E8E              ;
1445 4E8E              ;   SetMenuTitle
1446 4E8E              ;
1447 4E8E              ; Patch to clean up purged handles
1448 4E8E              ; 5/25/89 Mensch and Harry Yee
1449 4E8E              ;===========================================================================
1450 4E8E              SetMenuTitle proc 
1451 4E8E                       With CacheFixData 
1452 4E8E
1453 4E8E 20 C8 4D              jsr   localStartup
1454 4E91 A5 19                 lda   <barHand+1
1455 4E93 F0 19                 beq   NoBar
1456 4E95
1457 4E95 20 C4 4C              jsr   saveAllCache
1458 4E98
1459 4E98 3B                    tsc   
1460 4E99 5B                    tcd   
1461 4E9A D4 0E                 pei   Input+4
1462 4E9C D4 0C                 pei   Input+2
1463 4E9E D4 0A                 pei   Input
1464 4EA0 AF C2 4C 02           lda   >MenuZPage
1465 4EA4 22 B2 51 02           jsl   SetMenuTitleGlue
1466 4EA8
1467 4EA8 A0 00 00              ldy   #$0000
1468 4EAB 20 20 4D              jsr   DisposeCache
1469 4EAE 5C BB 8F FD  NoBar    jml   pop6Bytes
1470 4EB2
1471 4EB2 22 5D 79 FD  SetMenuTitleGlue jsl   ROMSetMenuTitle
1472 4EB6 6B                    rtl   
1473 4EB7                       endp 
1474 4EB7
1475 4EB7              ;===========================================================================
1476 4EB7              ;
1477 4EB7              ;   SetMenuTitle2
1478 4EB7              ;
1479 4EB7              ; Patch to clean up purged handles
1480 4EB7              ; 5/25/89 Mensch and Harry Yee
1481 4EB7              ;===========================================================================
1482 4EB7              SetMenuTitle2 proc 
1483 4EB7                       With CacheFixData 
1484 4EB7
1485 4EB7 20 C8 4D              jsr   localStartup
1486 4EBA A5 19                 lda   <barHand+1
1487 4EBC F0 1B                 beq   NoBar
1488 4EBE
1489 4EBE 20 C4 4C              jsr   saveAllCache
1490 4EC1
1491 4EC1 3B                    tsc   
1492 4EC2 5B                    tcd   
1493 4EC3 D4 10                 pei   Input+6
1494 4EC5 D4 0E                 pei   Input+4
1495 4EC7 D4 0C                 pei   Input+2
1496 4EC9 D4 0A                 pei   Input
1497 4ECB AF C2 4C 02           lda   >MenuZPage
1498 4ECF 22 DD 51 02           jsl   SetMenuTitle2Glue
1499 4ED3
1500 4ED3 A0 00 00              ldy   #$0000
1501 4ED6 20 20 4D              jsr   DisposeCache
1502 4ED9 5C C3 8F FD  NoBar    jml   pop8Bytes
1503 4EDD
1504 4EDD 22 01 79 FD  SetMenuTitle2Glue jsl   ROMSetMenuTitle2
1505 4EE1 6B                    rtl   
1506 4EE2                       endp 
1507 4EE2
1508 4EE2              ;===========================================================================
1509 4EE2              ;
1510 4EE2              ;   SetMTitleWidth
1511 4EE2              ;
1512 4EE2              ; Patch to clean up purged handles
1513 4EE2              ; 5/25/89 Mensch and Harry Yee
1514 4EE2              ;===========================================================================
1515 4EE2              SetMTitleWidth proc 
1516 4EE2                       With CacheFixData 
1517 4EE2
1518 4EE2 20 C8 4D              jsr   localStartup
1519 4EE5 A5 19                 lda   <barHand+1
1520 4EE7 F0 17                 beq   NoBar
1521 4EE9
1522 4EE9 20 C4 4C              jsr   saveAllCache
1523 4EEC
1524 4EEC 3B                    tsc   
1525 4EED 5B                    tcd   
1526 4EEE D4 0C                 pei   Input+2
1527 4EF0 D4 0A                 pei   Input
1528 4EF2 AF C2 4C 02           lda   >MenuZPage
1529 4EF6 22 04 52 02           jsl   SetMTitleWidthGlue
1530 4EFA
1531 4EFA A0 00 00              ldy   #$0000
1532 4EFD 20 20 4D              jsr   DisposeCache
1533 4F00 5C B3 8F FD  NoBar    jml   pop4Bytes
1534 4F04
1535 4F04 22 83 78 FD  SetMTitleWidthGlue jsl   ROMSetMTitleWidth
1536 4F08 6B                    rtl   
1537 4F09                       endp 
1538 4F09
1539 4F09              ;===========================================================================
1540 4F09              ;
1541 4F09              ;   SetMTitleSTart
1542 4F09              ;
1543 4F09              ; Patch to clean up purged handles
1544 4F09              ; 5/25/89 Mensch and Harry Yee
1545 4F09              ;===========================================================================
1546 4F09              SetMTitleSTart proc 
1547 4F09                       With CacheFixData 
1548 4F09
1549 4F09 20 C8 4D              jsr   localStartup
1550 4F0C A5 19                 lda   <barHand+1
1551 4F0E F0 15                 beq   NoBar
1552 4F10
1553 4F10 20 C4 4C              jsr   saveAllCache
1554 4F13
1555 4F13 3B                    tsc   
1556 4F14 5B                    tcd   
1557 4F15 D4 0A                 pei   Input
1558 4F17 AF C2 4C 02           lda   >MenuZPage
1559 4F1B 22 29 52 02           jsl   SetMTitleSTartGlue
1560 4F1F
1561 4F1F A0 FF FF              ldy   #$FFFF
1562 4F22 20 20 4D              jsr   DisposeCache
1563 4F25 5C AB 8F FD  NoBar    jml   pop2Bytes
1564 4F29
1565 4F29 22 1A 78 FD  SetMTitleSTartGlue jsl   ROMSetMTitleSTart
1566 4F2D 6B                    rtl   
1567 4F2E                       endp 
1568 4F2E
1569 4F2E              ;===========================================================================
1570 4F2E              ;
1571 4F2E              ;   InsertMenu
1572 4F2E              ;
1573 4F2E              ; Patch to clean up purged handles
1574 4F2E              ; 5/25/89 Mensch and Harry Yee
1575 4F2E              ;===========================================================================
1576 4F2E              InsertMenu proc 
1577 4F2E                       With CacheFixData 
1578 4F2E
1579 4F2E              *** added 15-May-91 DAL -- make sure this isn't a duplicate menu ID
1580 4F2E 48                    pha   
1581 4F2F 5A                    phy   
1582 4F30
1583 4F30 0B                    phd   
1584 4F31 A3 11                 lda   17,s
1585 4F33 48                    pha   
1586 4F34 A3 11                 lda   17,s
1587 4F36 48                    pha   
1588 4F37 3B                    tsc   
1589 4F38 5B                    tcd   
1590 4F39 A0 02 00              ldy   #2
1591 4F3C B7 01                 lda   [1],y
1592 4F3E AA                    tax   
1593 4F3F A7 01                 lda   [1]
1594 4F41 85 01                 sta   1
1595 4F43 86 03                 stx   3
1596 4F45 A7 01                 lda   [1]                      ;fetched menu id (first word in handle)
1597 4F47 FA                    plx   
1598 4F48 FA                    plx   
1599 4F49 2B                    pld                            ;A = menu ID (first word in menu handle)
1600 4F4A
1601 4F4A AA                    tax   
1602 4F4B F0 1A                 beq   @notDuplicate            ;I'm paranoid about the zero case
1603 4F4D
1604 4F4D 48                    pha   
1605 4F4E 48                    pha                            ;space for GetMHandle result
1606 4F4F 48                    pha                            ;menu ID
1607 4F50 A2 0F 16 22           _GetMHandle 
1608 4F57 FA                    plx   
1609 4F58 FA                    plx   
1610 4F59 F0 0C                 beq   @notDuplicate
1611 4F5B FA                    plx   
1612 4F5C FA                    plx                            ;throw away saved YA
1613 4F5D A0 06 00              ldy   #6
1614 4F60 A2 04 0F              ldx   #dupMenuID
1615 4F63 5C 84 01 E1           jml   $e10184                  ;ToStrip
1616 4F67 7A           @notDuplicate ply   
1617 4F68 68                    pla   
1618 4F69              *** end of 15-May-91 DAL
1619 4F69
1620 4F69 20 C8 4D              jsr   localStartup
1621 4F6C A5 19                 lda   <barHand+1
1622 4F6E F0 19                 beq   NoBar
1623 4F70
1624 4F70 20 C4 4C              jsr   saveAllCache
1625 4F73
1626 4F73 3B                    tsc   
1627 4F74 5B                    tcd   
1628 4F75 D4 0E                 pei   Input+4
1629 4F77 D4 0C                 pei   Input+2
1630 4F79 D4 0A                 pei   Input
1631 4F7B AF C2 4C 02           lda   >MenuZPage
1632 4F7F 22 8D 52 02           jsl   InsertMenuGlue
1633 4F83
1634 4F83 A0 00 00              ldy   #$0000
1635 4F86 20 20 4D              jsr   DisposeCache
1636 4F89 5C BB 8F FD  NoBar    jml   pop6Bytes
1637 4F8D
1638 4F8D 22 E2 75 FD  InsertMenuGlue jsl   ROMInsertMenu
1639 4F91 6B                    rtl   
1640 4F92                       endp 
1641 4F92
1642 4F92              ;===========================================================================
1643 4F92              ;
1644 4F92              ;   MenuSelect
1645 4F92              ;
1646 4F92              ; Patch to clean up purged handles
1647 4F92              ; 5/25/89 Mensch and Harry Yee
1648 4F92              ;
1649 4F92              ;===========================================================================
1650 4F92              MenuSelect proc 
1651 4F92                       With CacheFixData 
1652 4F92
1653 4F92 20 C8 4D              jsr   localStartup
1654 4F95
1655 4F95              ;***
1656 4F95              ;*** 19-Sep-90 DAL: the G_INITCURSOR bit in MenuGlobal makes MenuSelect call InitCursor
1657 4F95              ;***
1658 4F95              ;*** Direct page is already set to Menu Mgr direct page
1659 4F95              ;***
1660 4F95              ;	lda	<globalFlag
1661 4F95              ;	and	#G_INITCURSOR
1662 4F95              ;	beq	@noInitCursor
1663 4F95              ;	_InitCursor
1664 4F95              ;@noInitCursor
1665 4F95              ;*** end of 19-Sep-90 DAL addition
1666 4F95
1667 4F95 20 B3 4D              jsr   localsetCurrentBar
1668 4F98
1669 4F98 20 C4 4C              jsr   SaveAllCache             ; this is the fix
1670 4F9B
1671 4F9B 3B                    tsc   
1672 4F9C 5B                    tcd   
1673 4F9D D4 10                 pei   Input+6
1674 4F9F D4 0E                 pei   Input+4
1675 4FA1 D4 0C                 pei   Input+2
1676 4FA3 D4 0A                 pei   Input
1677 4FA5 AF C2 4C 02           lda   >MenuZPage
1678 4FA9 22 BD 52 02           jsl   MenuSelectGlue           ; now call the real menu select
1679 4FAD
1680 4FAD B0 0A                 bcs   @error
1681 4FAF A0 00 00              ldy   #0
1682 4FB2 20 20 4D              jsr   DisposeCache
1683 4FB5 A9 00 00              lda   #0
1684 4FB8 18                    clc   
1685 4FB9              @Error    
1686 4FB9 5C C3 8F FD           jml   pop8Bytes                ; now exit the call
1687 4FBD
1688 4FBD              ;;;MenuSelectGlue	jsl	ROMMenuSelect
1689 4FBD              ;;;	rtl
1690 4FBD
1691 4FBD              *** added 8-Feb-92 DAL -- Patch beginning of MenuSelect to disallow pulling down
1692 4FBD              ***   a menu too close to the bottom of the screen.
1693 4FBD
1694 4FBD 22 C2 52 02  MenuSelectGlue jsl   DaveMenuSelectPatch
1695 4FC1 6B                    rtl   
1696 4FC2
1697 4FC2              eventPtr equ   $ea
1698 4FC2
1699 4FC2 20 C8 4D     DaveMenuSelectPatch jsr   localStartup
1700 4FC5 20 B3 4D              jsr   localSetCurrentBar       ;<barHand = passed menu bar
1701 4FC8 4B F4 D2 52           ROMCALL lockMenuBar            ;<barPtr = (<barHand), bar & menus locked
1702 4FD3 F0 41                 beq   toExitMenu2
1703 4FD5
1704 4FD5 A3 0E                 lda   $10-2,s
1705 4FD7 85 EA                 sta   <eventPtr
1706 4FD9 A3 10                 lda   $12-2,s
1707 4FDB 85 EC                 sta   <eventPtr+2              ;get event pointer
1708 4FDD
1709 4FDD A0 0A 00              ldy   #where                   ;get point of event
1710 4FE0 B7 EA                 lda   [<eventptr],y
1711 4FE2 85 3A                 sta   <yrat
1712 4FE4 C8                    iny   
1713 4FE5 C8                    iny   
1714 4FE6 B7 EA                 lda   [<eventptr],y
1715 4FE8 85 3C                 sta   <xrat
1716 4FEA
1717 4FEA 4B F4 F4 52           ROMCALL to_myport 
1718 4FF5
1719 4FF5              *** The new code -- If Top of menu bar >= 150, don't do anything, it's dangerous!
1720 4FF5 F4 00 00              pea   0                        ;dummy X value
1721 4FF8 A0 08 00              ldy   #8                       ;offset to menu bar rect, top
1722 4FFB B7 14                 lda   [<barptr],y
1723 4FFD 48                    pha                            ;local-coord top of menu bar
1724 4FFE 3B                    tsc   
1725 4FFF 1A                    inc   a
1726 5000 F4 00 00              pea   0                        ;high word of point ptr
1727 5003 48                    pha                            ;low word of point ptr
1728 5004 A2 04 84 22           _LocalToGlobal 
1729 500B 68                    pla                            ;global Y value
1730 500C FA                    plx                            ;ignore X value
1731 500D C9 96 00              cmp   #150
1732 5010 B0 08                 bcs   toExit
1733 5012              *** end of the new code
1734 5012 5C DD 6B FD           jml   >$fd6bdd                 ;back into ROM 3!
1735 5016
1736 5016 5C 2C 6C FD  toExitMenu2 jml   >$fd6c2c
1737 501A
1738 501A 5C 0A 6C FD  toExit   jml   >$fd6c0a                 ;return menu/item = 0
1739 501E              *** end 8-Feb-92
1740 501E
1741 501E
1742 501E                       EndP 
1743 501E
1744 501E
1745 501E              ;===========================================================================
1746 501E              ;
1747 501E              ; NewMenuBar2
1748 501E              ;
1749 501E              ; 9/07/89           Yee
1750 501E              ; When the menubar is defined as a resource, once we're done with the resource
1751 501E              ; it's not being disposed of properly. When the high word of the resource ID
1752 501E              ; is non-zero we crash.
1753 501E              ;
1754 501E              ;===========================================================================
1755 501E              NewMenuBar2 PROC 
1756 501E
1757 501E                       DefineStack 
1758 501E              menuBarPtr long 
1759 501E              theHandle long 
1760 501E              origMenuBarRef long 
1761 501E              count1   word 
1762 501E              count2   word 
1763 501E              mem_needed word 
1764 501E
1765 501E              OrigB    byte 
1766 501E              OrigD    word 
1767 501E              RTLAdr1  block 3 
1768 501E              RTLAdr2  block 3 
1769 501E              menuOwner long 
1770 501E              menuBarRef long 
1771 501E              refDescriptor word 
1772 501E              result   long 
1773 501E
1774 501E              zPageSize equ   OrigB-menuBarPtr
1775 501E
1776 501E 22 64 00 E1           jsl   IncBusyFlg
1777 5022
1778 5022 0B                    phd   
1779 5023 8B                    phb   
1780 5024 F4 FD FD              pea   $FDFD
1781 5027 AB                    plb   
1782 5028 AB                    plb   
1783 5029
1784 5029 3B                    tsc   
1785 502A 38                    sec   
1786 502B E9 12 00              sbc   #zPageSize
1787 502E 1B                    tcs   
1788 502F 5B                    tcd                            ;switch direct page into stack
1789 5030
1790 5030 64 05                 stz   <theHandle
1791 5032 64 07                 stz   <theHandle+2
1792 5034 64 09                 stz   <origMenuBarRef
1793 5036 64 0B                 stz   <origMenuBarRef+2
1794 5038 64 11                 stz   <mem_needed
1795 503A
1796 503A 48                    pha                            ;space for menu bar handle
1797 503B 48                    pha   
1798 503C D4 1E                 pei   <menuOwner+2
1799 503E D4 1C                 pei   <menuOwner
1800 5040 A2 0F 15 22           _NewMenuBar                    ;get a new menu bar
1801 5047
1802 5047 68                    pla                            ;store menu bar hdl in our direct page
1803 5048 85 26                 sta   <result
1804 504A 68                    pla   
1805 504B 85 28                 sta   <result+2
1806 504D
1807 504D A5 24                 lda   <refDescriptor
1808 504F 0A                    asl   a
1809 5050 AA                    tax   
1810 5051 7C 54 53              jmp   (table,x)
1811 5054
1812 5054 6A 53        table    DC W:pointer
1813 5056 66 53                 DC W:handle
1814 5058 5A 53                 DC W:resourceID
1815 505A
1816 505A A5 20        resourceID lda   <menuBarRef            ;save resource ID so we can use it to release this
1817 505C 85 09                 sta   <origMenuBarRef          ;resource later
1818 505E A5 22                 lda   <menuBarRef+2
1819 5060 85 0B                 sta   <origMenuBarRef+2
1820 5062
1821 5062 5C 5F 5E FD           jml   $FD5E5F                  ;jump back into the ROM
1822 5066
1823 5066 5C 77 5E FD  handle   jml   $FD5E77                  ;jump back into the ROM
1824 506A
1825 506A 5C 93 5E FD  pointer  jml   $FD5E93
1826 506E
1827 506E
1828 506E                       ENDP 
1829 506E
1830 506E
1831 506E              ;===========================================================================
1832 506E              ;
1833 506E              ; HideMenuBar -- ROM 3 patch 26-Aug-91 DAL
1834 506E              ;
1835 506E              ; HideMenuBar in ROM is setting all SCBs to the MasterSCB, which is overkill,
1836 506E              ; and a couple developers complained.  So now it only sets the ones that
1837 506E              ; InitPalette messes with (2 through 9).
1838 506E              ;
1839 506E              ; Original function is at $FD608B in ROM 3.
1840 506E              ;
1841 506E              ;===========================================================================
1842 506E              HideMenuBar PROC 
1843 506E
1844 506E 20 C8 4D              jsr   localStartup
1845 5071
1846 5071 A5 09                 lda   <sysMenu+1               First check if there is a system menu bar
1847 5073 F0 5B                 beq   exit1
1848 5075
1849 5075 4B 62 06 00           jsrlFD $6282                   ; sys_current; <barHand = <sysMen. Current = system
1850 5080 4B 62 06 00           jsrlFD $628B                   ; lockmenubar
1851 508B
1852 508B A0 10 00              ldy   #CtlFlag
1853 508E B7 14                 lda   [<barptr],y
1854 5090 AA                    tax   
1855 5091 29 80 00              and   #$0080                   First check if menu bar is already invisible
1856 5094 D0 3E                 bne   ItsInvisible
1857 5096
1858 5096 8A                    txa   
1859 5097 09 80 00              ora   #$0080                   Set invisible flag for menu bar
1860 509A 97 14                 sta   [<barptr],y
1861 509C
1862 509C A9 01 00              lda   #1                       Set Desktop operation for "toDesk", since we are hiding the
1863 509F 85 58                 sta   <temp                    menu bar we need to add the rect back to the desktop.
1864 50A1 4B 62 06 00           jsrlFD $6114                   ; AddorSubRegion
1865 50AC
1866 50AC 48                    pha                            Reset all the SCBs which were initially altered
1867 50AD A2 04 17 22           _GetMasterSCB by InitPalette.
1868 50B4              ;;;	_SetAllSCBs
1869 50B4              *** Newer way 19-Sep-91 DAL -- set SCBs 0..Height-1
1870 50B4 A0 0C 00              ldy   #$000C                   ;offset to bottom om menu bar rect
1871 50B7 B7 14                 lda   [<barPtr],y
1872 50B9 3A                    dec   a
1873 50BA AA                    tax   
1874 50BB 68                    pla                            ;A = SCB value
1875 50BC DA           @setNextSCB phx   
1876 50BD 48                    pha                            ;preserve A and X
1877 50BE DA                    phx   
1878 50BF 48                    pha                            ;push SetSCB parameters
1879 50C0 A2 04 12 22           _SetSCB 
1880 50C7 68                    pla   
1881 50C8 FA                    plx   
1882 50C9 CA                    dex   
1883 50CA 10 F0                 bpl   @setNextSCB
1884 50CC              *** end 19-Sep-91 DAL
1885 50CC
1886 50CC 5C C0 60 FD           jml   >$fd60c0                 ;--> LDX <barptr+2, lda <barptr
1887 50D0
1888 50D0 5C D7 60 FD  exit1    jml   >$fd60d7
1889 50D4 5C D4 60 FD  ItsInvisible jml   >$fd60d4
1890 50D8
1891 50D8                       EndP 
1892 50D8
1893 50D8
1894 50D8              ;===========================================================================
1895 50D8              ;
1896 50D8              ;   PopUpMenuSelect
1897 50D8              ;
1898 50D8              ;   Handle user interaction with pop-up menu. The bits M_CACHE and M_POPUP
1899 50D8              ;   must be set in the menu flag. Upon entering these bits are set and
1900 50D8              ;   restored to there original state when you exit.
1901 50D8              ;
1902 50D8              ;   IN:  PUSH:LONG - menuin: handle to menu
1903 50D8              ;        PUSH:WORD - popupflag: tells us what type of popup you want
1904 50D8              ;                                   $0001 = with white space
1905 50D8              ;        PUSH:WORD - yloc:   top of current selection
1906 50D8              ;        PUSH:WORD - xloc:   left side of "popped-up" menu
1907 50D8              ;        PUSH:WORD - itemnum:item ID of current selection
1908 50D8              ;
1909 50D8              ;  OUT:  WORD - item selected
1910 50D8              ;
1911 50D8              ;===========================================================================
1912 50D8              PopUpMenuSelect PROC 
1913 50D8
1914 50D8              menuin   equ   input
1915 50D8              popupflag equ   menuin+4
1916 50D8              yloc     equ   popupflag+2
1917 50D8              xloc     equ   yloc+2
1918 50D8              itemnum  equ   xloc+2
1919 50D8              return   equ   itemnum+2
1920 50D8
1921 50D8              *
1922 50D8              * New layer around PopUpMenuSelect patch, 16-Jan-91 DAL
1923 50D8              *
1924 50D8              * Disable fastPort during the call, since the ROM is plastering
1925 50D8              * values back into the grafport during popPortData.
1926 50D8              *
1927 50D8              QDDirtyFlags equ   $02EC
1928 50D8
1929 50D8 48                    pha                            ;save our WAP (low word)
1930 50D9
1931 50D9 48                    pha   
1932 50DA 48                    pha   
1933 50DB F4 00 00              pea   0
1934 50DE F4 04 00              pea   4                        ;QuickDraw
1935 50E1 A2 01 0C 22           _GetWAP 
1936 50E8 FA                    plx   
1937 50E9 68                    pla   
1938 50EA BF EC 02 00           lda   >QDDirtyFlags,x
1939 50EE 48                    pha   
1940 50EF DA                    phx   
1941 50F0 A9 00 00              lda   #0
1942 50F3 9F EC 02 00           sta   >QDDirtyFlags,x
1943 50F7
1944 50F7              InputParameters equ   13                ;xxx,s
1945 50F7
1946 50F7 A2 07 00              ldx   #7                       ;push 7 words for the real call
1947 50FA A3 19        @push    lda   InputParameters+12,s
1948 50FC 48                    pha   
1949 50FD CA                    dex   
1950 50FE D0 FA                 bne   @push
1951 5100
1952 5100 A3 13                 lda   5+14,s                   ;get our WAP back (low word)
1953 5102 22 1C 54 02           jsl   ToOldPatch
1954 5106 A8                    tay                            ;error code
1955 5107
1956 5107 68                    pla   
1957 5108 83 19                 sta   InputParameters+12,s     ;put the result into the caller's result space
1958 510A
1959 510A FA                    plx   
1960 510B 68                    pla   
1961 510C 29 00 80              and   #$8000                   ;just restore the enable/disable fastPort status (nothing cached)
1962 510F 9F EC 02 00           sta   >QDDirtyFlags,x
1963 5113
1964 5113 68                    pla                            ;throw out copy of our WAP
1965 5114 BB                    tyx                            ;error code
1966 5115 A0 0C 00              ldy   #12
1967 5118 5C 84 01 E1           jml   $e10184                  ;ToStrip
1968 511C
1969 511C
1970 511C 22 21 54 02  ToOldPatch jsl   OldPopUpMenuSelectPatch
1971 5120 6B                    rtl   
1972 5121
1973 5121              OldPopUpMenuSelectPatch  
1974 5121                       import pushPortData,popPortData 
1975 5121                       import pull_down2 
1976 5121
1977 5121 20 C8 4D              jsr   LocalStartup
1978 5124
1979 5124 4B F4 2E 54           ROMCALL lockmenubar 
1980 512F
1981 512F 4B F4 39 54           ROMCALL saveColor 
1982 513A 4B F4 44 54           ROMCALL GetColor 
1983 5145
1984 5145 A3 0A                 lda   menuin,s
1985 5147 85 20                 sta   <menuhand
1986 5149 A3 0C                 lda   menuin+2,s
1987 514B 85 22                 sta   <menuhand+2
1988 514D
1989 514D 4B F4 57 54           ROMCALL lockmenuhand 
1990 5158 4B F4 62 54           ROMCALL derefmenuhand 
1991 5163
1992 5163 A0 0A 00              ldy   #menuFlag
1993 5166 B7 1C                 lda   [<menuptr],y
1994 5168 48                    pha   Save original menuFlag on the stack
1995 5169 09 01 00              ora   #M_POPUP                 Set the bit that says this is a pop-up menu
1996 516C 29 F7 FF              and   #_M_CACHE                Clear cache bit, pop-up menus cannot be cached
1997 516F 97 1C                 sta   [<menuptr],y
1998 5171
1999 5171 4B F4 7B 54           ROMCALL InitStuff initialize some zero page equates
2000 517C
2001 517C 4B F4 86 54           ROMCALL getifirst get first item in menu
2002 5187 F0 13        checkNext beq   invalidItem             item not found, so return invalid item error
2003 5189 E6 D4                 inc   <currentSel              offset of item in list
2004 518B C3 16                 cmp   itemnum+2,s              have we found our initial selection?
2005 518D F0 25                 beq   gotit
2006 518F 4B F4 99 54           ROMCALL next_item 
2007 519A 80 EB                 bra   checkNext
2008 519C
2009 519C A0 0C 00     invalidItem ldy   #NumOfItems           make sure the menu is not empty before assigning init. sel 
2010 519F B7 1C                 lda   [<menuptr],y             to first item in the menu list
2011 51A1 D0 0C                 bne   @888
2012 51A3 A9 01 00              lda   #1
2013 51A6 85 4A                 sta   <menurect+x1
2014 51A8 3A                    dec   a
2015 51A9 85 4E                 sta   <menurect+x2
2016 51AB 5C B1 69 FD           jml   popEmptyInROM
2017 51AF A9 01 00     @888     lda   #1                       If item ID is invalid then I default to the first 
2018 51B2 85 D4                 sta   <currentSel              item in the menu list.
2019 51B4
2020 51B4 20 83 50     gotit    jsr   mSizeDispatch            get menu width and height
2021 51B7
2022 51B7              ;=============================================================================
2023 51B7              ; calculate pop-up rectangle
2024 51B7              ;
2025 51B7 A3 12                 lda   yloc+2,s
2026 51B9 3A                    dec   a
2027 51BA 85 48                 sta   <menurect+y1             top of menu
2028 51BC A3 14                 lda   xloc+2,s
2029 51BE 85 4A                 sta   <menurect+x1             left edge of menu
2030 51C0
2031 51C0 A0 02 00              ldy   #menuwidth
2032 51C3 18                    clc   
2033 51C4 77 1C                 adc   [<menuptr],y
2034 51C6 85 4E                 sta   <menurect+x2             right edge of menu
2035 51C8
2036 51C8 A0 04 00              ldy   #menuheight
2037 51CB B7 1C                 lda   [<menuptr],y
2038 51CD 18                    clc   
2039 51CE 65 48                 adc   <menurect+y1             bottom of menu
2040 51D0 1A                    inc   a                        make room for drop shadow
2041 51D1 85 4C                 sta   <menurect+y2
2042 51D3
2043 51D3 A3 10                 lda   popupflag+2,s
2044 51D5 29 40 00              and   #FType2PopUp
2045 51D8 85 E2                 sta   <saveY1
2046 51DA
2047 51DA A5 D4                 lda   <currentSel              a-reg contains input to adjust rect
2048 51DC 4B F4 E6 54           ROMCALL adjustRect adjust rectangle to reflect current selection
2049 51E7
2050 51E7 A5 D4                 lda   <currentSel              If the current selection is the first item in list then
2051 51E9 C9 01 00              cmp   #1                       top of pop-up can't be adjusted any further.
2052 51EC F0 0B                 beq   noAdjustTop
2053 51EE
2054 51EE 4B F4 F8 54           ROMCALL adjustTop current port rectangle
2055 51F9
2056 51F9 A5 D4        noAdjustTop lda   <currentSel           If the current selection is the last item in the menu then
2057 51FB C5 D2                 cmp   <lastVisItem             the bottom cannot be adjusted any further.
2058 51FD F0 14                 beq   noAdjustBott
2059 51FF 1A                    inc   a
2060 5200 C5 D2                 cmp   <lastVisItem
2061 5202 D0 04                 bne   @99
2062 5204 A5 E2                 lda   <saveY1
2063 5206 F0 0B                 beq   noAdjustBott
2064 5208
2065 5208              @99       
2066 5208 4B F4 12 55           ROMCALL adjustBottom 
2067 5213
2068 5213              noAdjustBott  
2069 5213 A5 F0                 lda   <portRect+x1
2070 5215 D0 1C                 bne   CheckLeftSideFirst
2071 5217
2072 5217 A6 F0                 ldx   <portRect+x1
2073 5219 A5 F4                 lda   <portRect+x2
2074 521B 4B F4 25 55           ROMCALL justifyRight           ;Move menu left if off right
2075 5226 4B F4 30 55           ROMCALL justifyLeft            ;Move menu right if off left
2076 5231 80 1E                 bra   around
2077 5233
2078 5233              CheckLeftSideFirst  
2079 5233 A6 F0                 ldx   <portRect+x1
2080 5235 A5 F4                 lda   <portRect+x2
2081 5237 4B F4 41 55           ROMCALL justifyLeft 
2082 5242 A6 F0                 ldx   <portRect+x1
2083 5244 A5 F4                 lda   <portRect+x2
2084 5246 4B F4 50 55           ROMCALL justifyRight 
2085 5251
2086 5251              around    
2087 5251 A5 E2                 lda   <saveY1
2088 5253 F0 0B                 beq   @222
2089 5255
2090 5255 4B F4 5F 55           ROMCALL doWhiteSpace           ;user wants the pop-up with the white space
2091 5260
2092 5260 E6 DE        @222     inc   <specialFlag             ;flag that tells pull_down2 to just draw box and shadow
2093 5262 20 A9 5C              jsr   pushPortData             ;save grafport vars...
2094 5265
2095 5265              ;
2096 5265              ; Init rect x1 and x2
2097 5265              ;
2098 5265 A5 4A                 lda   <menurect+x1
2099 5267 18                    clc   
2100 5268 65 5A                 adc   <vert_pen
2101 526A 85 0E                 sta   <rect+x1
2102 526C A5 4E                 lda   <menurect+x2
2103 526E 38                    sec   
2104 526F E5 5A                 sbc   <vert_pen
2105 5271 3A                    dec   a                        subtract right drop shadow, so that drop shadow
2106 5272 3A                    dec   a                        is inside the menu rect
2107 5273 A6 46                 ldx   <screenmode
2108 5275 F0 02                 beq   storeit
2109 5277 3A                    dec   a
2110 5278 3A                    dec   a
2111 5279 85 12        storeit  sta   <rect+x2
2112 527B
2113 527B              *** changed 8-Feb-92 DAL to patch out some more, down to jsr get_ids
2114 527B              ;;;	pea	|RightAfterPullDown2Call-1
2115 527B              ;;;;	brl	pull_down2	draw the pop-up box, drop shadow
2116 527B              ;;;
2117 527B              ;;;
2118 527B              ;;;; It never comes back, the code jumps into ROM inside pull_down2
2119 527B              ;;;
2120 527B 4B F4 85 55           ROMCALL pull_down2             ;not ROM, but it jumps there, so this works.
2121 5286              *** copied from menumgr.asm 8-Feb-92
2122 5286 C6 DE                 dec   <specialFlag             ;in ROM 3, this was at $FD/6988
2123 5288
2124 5288 A5 48                 lda   <menurect+y1
2125 528A 1A                    inc   a
2126 528B 48                    pha   
2127 528C A5 4C                 lda   <menurect+y2
2128 528E 3A                    dec   a
2129 528F 48                    pha   
2130 5290
2131 5290 A5 E4                 lda   <saveY2
2132 5292 D0 09                 bne   @333
2133 5294
2134 5294 A5 48                 lda   <menurect+y1
2135 5296 18                    clc   
2136 5297 65 E2                 adc   <saveY1
2137 5299 85 48                 sta   <menurect+y1
2138 529B 80 07                 bra   saveWhite
2139 529D
2140 529D A5 4C        @333     lda   <menurect+y2
2141 529F 38                    sec   
2142 52A0 E5 E2                 sbc   <saveY1
2143 52A2 85 4C                 sta   <menurect+y2
2144 52A4
2145 52A4 68           saveWhite pla   
2146 52A5 85 E4                 sta   <saveY2
2147 52A7 68                    pla   
2148 52A8 85 E2                 sta   <saveY1
2149 52AA
2150 52AA A5 4A                 lda   <menurect+x1
2151 52AC 18                    clc   
2152 52AD 65 5A                 adc   <vert_pen
2153 52AF 85 0E                 sta   <rect+x1
2154 52B1 A5 4E                 lda   <menurect+x2
2155 52B3 38                    sec   
2156 52B4 E5 5A                 sbc   <vert_pen
2157 52B6 85 12                 sta   <rect+x2
2158 52B8
2159 52B8 4B F4 C2 55           ROMCALL $fd6ece                ;NeverMind
2160 52C3 80 03                 bra   SkipPopEmpty
2161 52C5 20 A9 5C     popEmpty jsr   PushPortData
2162 52C8              SkipPopEmpty  
2163 52C8 4B F4 D2 55           ROMCALL $fd63da                ;trackMenu2--track the mouse in the menu until a mouse up
2164 52D3 20 D6 5C              jsr   popPortData              ;restore this grafport
2165 52D6 A5 54                 lda   <curselect               ;get user selection and return it on the stack
2166 52D8 F0 0B                 beq   toNoSelection
2167 52DA              *** 7-Dec-91 DAL -- call get_ids instead of loading [<itemptr] -- for custom pop-up support!
2168 52DA              ;;;	lda	[<itemptr]	;get the ID
2169 52DA 4B F4 E4 55           ROMCALL $fd6878                ;get_ids
2170 52E5              *** end 7-Dec-91
2171 52E5
2172 52E5 5C C0 69 FD  toNoSelection jml   >$fd69c0            ;back to noSelection in ROM 3
2173 52E9
2174 52E9              *** end of 8-Feb-92 changes
2175 52E9
2176 52E9                       ENDP 
2177 52E9
2178 52E9
2179 52E9              ;------------------------------------------------------------------
2180 52E9              ;
2181 52E9              ;
2182 52E9              ;
2183 52E9              pull_down2 PROC 
2184 52E9
2185 52E9 64 44                 stz   <sav_buff+2              Set 'no cache' flag just in case.
2186 52EB 64 42                 stz   <sav_buff
2187 52ED
2188 52ED A0 0A 00              ldy   #MenuFlag                Check if there can be a cache.
2189 52F0 B7 1C                 lda   [<menuptr],y
2190 52F2 29 08 00              and   #M_CACHE
2191 52F5 D0 32                 bne   cacheOK
2192 52F7
2193 52F7 4B F4 01 56           ROMCALL allocateCache 
2194 5302 90 03                 bcc   @GotCache
2195 5304 82 82 00              brl   noCache
2196 5307 DA           @GotCache phx   Save allocated cache.
2197 5308 48                    pha   
2198 5309 85 42                 sta   <sav_buff                Dereference cache.
2199 530B 86 44                 stx   <sav_buff+2
2200 530D A0 02 00              ldy   #2
2201 5310 B7 42                 lda   [<sav_buff],y
2202 5312 A8                    tay   
2203 5313 A7 42                 lda   [<sav_buff]
2204 5315 85 42                 sta   <sav_buff
2205 5317 84 44                 sty   <sav_buff+2
2206 5319
2207 5319 A9 00 00              lda   #0                       Mark cache as BAD (not containing menu).
2208 531C 87 42                 sta   [<sav_buff]
2209 531E
2210 531E 68                    pla                            Put cache handle into sav_buff.
2211 531F 85 42                 sta   <sav_buff
2212 5321 68                    pla   
2213 5322 09 00 80              ora   #$8000                   Set temp cache flag.
2214 5325 85 44                 sta   <sav_buff+2
2215 5327 80 2F                 bra   saveScreen
2216 5329
2217 5329 A0 15 00     cacheOK  ldy   #MenuCache+1
2218 532C B7 1C                 lda   [<menuptr],y
2219 532E 85 43                 sta   <sav_buff+1
2220 5330 F0 0F                 beq   tryCache                 Is there a cache?
2221 5332 88                    dey   
2222 5333 B7 1C                 lda   [<menuptr],y
2223 5335 85 42                 sta   <sav_buff
2224 5337
2225 5337 A0 01 00              ldy   #1                       Has the cache been purged?
2226 533A B7 42                 lda   [<sav_buff],y
2227 533C D0 1A                 bne   saveScreen
2228 533E
2229 533E 20 50 4E              jsr   myfreeCache              Free purged cache.
2230 5341
2231 5341 4B F4 4B 56  tryCache ROMCALL makeCache Allocate a new cache for the menu.
2232 534C
2233 534C A0 14 00              ldy   #MenuCache
2234 534F B7 1C                 lda   [<menuptr],y
2235 5351 85 42                 sta   <sav_buff
2236 5353 C8                    iny   
2237 5354 B7 1C                 lda   [<menuptr],y
2238 5356 85 43                 sta   <sav_buff+1
2239 5358              ;
2240 5358              ; --- Save screen to buffer ---------------------------------
2241 5358
2242 5358 A5 43        saveScreen lda   <sav_buff+1
2243 535A F0 2D                 beq   noCache                  Is there a cache?
2244 535C
2245 535C F4 00 00              pea   0                        Pass no purge flag.
2246 535F              ***	pei	<sav_buff+2	Pass cache handle.
2247 535F              *** fixed 21-May-91 DAL -- bit 31 is a flag, so let's mask it off
2248 535F A5 44                 lda   <sav_buff+2
2249 5361 29 FF 00              and   #$00ff
2250 5364 48                    pha                            ;added 22-May-91 DAL -- oops
2251 5365              *** end of 21-May-91 DAL
2252 5365 D4 42                 pei   <sav_buff
2253 5367 A2 02 24 22           _SetPurge Make cache nonpurgeable for now.
2254 536E
2255 536E
2256 536E              ;
2257 536E              ; Fool cache to think bottom of menuRect is 200 or less
2258 536E              ;
2259 536E A5 4C                 lda   <menurect+y2
2260 5370 48                    pha   
2261 5371 C9 C8 00              cmp   #200
2262 5374 90 03                 bcc   @1
2263 5376 A9 C8 00              lda   #200
2264 5379 85 4C        @1       sta   <menuRect+y2
2265 537B
2266 537B 4B F4 85 56           ROMCALL cache 
2267 5386              ;
2268 5386              ; Put it all back
2269 5386 FA                    plx   
2270 5387 86 4C                 stx   <menurect+y2
2271 5389
2272 5389              NoCache   
2273 5389 5C EC 6D FD           jml   BackIntoROMSucker
2274 538D
2275 538D                       EndP 
2276 538D
2277 538D
2278 538D              ;==========================================================================
2279 538D              ;
2280 538D              ;                   GetPopUpDefProc
2281 538D              ;
2282 538D              ;                   Return the address of the pop-up definition procedure.
2283 538D              ;
2284 538D              ;   IN:    None.
2285 538D              ;
2286 538D              ;  OUT:    Address of list definition procedure.
2287 538D              ;==========================================================================
2288 538D              GetPopUpDefProc PROC 
2289 538D                       import PopupProc 
2290 538D
2291 538D              TheResult equ   7
2292 538D
2293 538D A9 02 00              lda   #PopupProc>>16           Pass pointer to list control defProc.
2294 5390 83 09                 sta   TheResult+2,s
2295 5392 A9 94 5F              lda   #PopupProc
2296 5395 83 07                 sta   TheResult,s
2297 5397
2298 5397 82 34 F5              brl   QuickReturn
2299 539A
2300 539A                       ENDP 
2301 539A
2302 539A
2303 539A              ;===========================================================================
2304 539A              ;
2305 539A              ;                   DrawItemIcon
2306 539A              ;
2307 539A              ;  IN: <itemptr pts to item record currently being worked on
2308 539A              ;
2309 539A              ; OUT: if item has an icon associated with it then we draw it, otherwise
2310 539A              ;      we just return
2311 539A              ;
2312 539A              ;===========================================================================
2313 539A              DrawItemIcon PROC 
2314 539A
2315 539A 20 85 4F              jsr   GetStruct
2316 539D A0 00 00              ldy   #itemflag2
2317 53A0 B7 28                 lda   [<temptr],y
2318 53A2 10 44                 bpl   @noIcon
2319 53A4              ;
2320 53A4              ; Setup parameters for PPToPort to draw the icon.
2321 53A4              ;
2322 53A4 20 F5 4F              jsr   getrItemIcon             x = high word of ref to icon record, a = low word
2323 53A7 DA                    phx                            a & x contain pointer to icon structure.
2324 53A8 48                    pha   
2325 53A9
2326 53A9 F4 00 00              pea   0                        Display mode.
2327 53AC
2328 53AC A5 62                 lda   <text_width
2329 53AE 18                    clc                            don't wan't any carry to be rotating in on us
2330 53AF 6A                    ror   a
2331 53B0 18                    clc   
2332 53B1 65 0E                 adc   <rect+x1
2333 53B3 65 62                 adc   <text_width              Ident 1 1/2 times the width of 'W' to make room for mark 
2334 53B5 48                    pha                            x coordinate of upper left corner of destination
2335 53B6
2336 53B6              ;
2337 53B6              ; Center icon in <rect
2338 53B6              ;
2339 53B6 20 44 50              jsr   GetIconInfo
2340 53B9 DA                    phx                            get height of icon
2341 53BA A5 10                 lda   <rect+y2
2342 53BC 38                    sec   
2343 53BD E5 0C                 sbc   <rect+y1                 calculate the height of the item's rect
2344 53BF 38                    sec   
2345 53C0 E3 01                 sbc   1,s                      subtract height of icon from height of item rect
2346 53C2 18                    clc   
2347 53C3 6A                    ror   a                        take half of that to use to center icon
2348 53C4 83 01                 sta   1,s
2349 53C6 A5 0C                 lda   <rect+y1                 add this to the y1 coordinate of item rect  
2350 53C8 18                    clc                            to get the y coordinate of the upper left corner 
2351 53C9 63 01                 adc   1,s                      of the destination
2352 53CB 83 01                 sta   1,s
2353 53CD              *** added 26-Mar-91 DAL to make the color right (stolen from MenuMgr.asm)
2354 53CD A3 03                 lda   3,s
2355 53CF 29 FE FF              and   #$fffe
2356 53D2 83 03                 sta   3,s
2357 53D4              *** end of 26-Mar-91 DAL
2358 53D4 A2 12 0B 22           _DrawIcon 
2359 53DB 90 0B                 bcc   @noIcon
2360 53DD C9 02 00              cmp   #$0002                   QDAux not started?
2361 53E0 D0 06                 bne   @noIcon
2362 53E2
2363 53E2 3B                    tsc   
2364 53E3 18                    clc                            Clean up stack.
2365 53E4 69 0A 00              adc   #10
2366 53E7 1B                    tcs   
2367 53E8              @noIcon   
2368 53E8 60                    rts   
2369 53E9
2370 53E9                       ENDP 
2371 53E9
2372 53E9              ;==========================================================================
2373 53E9              ;
2374 53E9              ; DoADirtyDeed2
2375 53E9              ;
2376 53E9              ; Patches return address from SetForeColor call to return to the patch for
2377 53E9              ; routine text_guts.
2378 53E9              ;
2379 53E9              ;==========================================================================
2380 53E9              DoADirtyDeed2 PROC EXPORT 
2381 53E9              RTL1     equ   1                        ; stack offsets from SetForeColor
2382 53E9              MenuRTL  equ   RTL1+3
2383 53E9              theForeColor equ   MenuRTL+3
2384 53E9
2385 53E9              BackIntoTextGuts equ   $FD730C
2386 53E9
2387 53E9              ; the code leading up to this point...
2388 53E9              ;
2389 53E9              ; 	ldy	<norcolor	Normal color.
2390 53E9              ; 	tax	Is item selected?
2391 53E9              ; 	beq	ok1
2392 53E9              ;	ldy	<hiliteclr	If yes, use hilite color.
2393 53E9              ; ok1	tya
2394 53E9              ;	and	#$000F
2395 53E9              ;	jsr	pushSmearLow	Push smeared color
2396 53E9              ;	_SetForeColor
2397 53E9              ;
2398 53E9
2399 53E9 AF F8 56 02           lda   >PatchEntry2
2400 53ED 83 04                 sta   MenuRTL,s
2401 53EF AF F9 56 02           lda   >PatchEntry2+1
2402 53F3 83 05                 sta   MenuRTL+1,s
2403 53F5 82 4C 21              brl   FinishSetForeColor
2404 53F8
2405 53F8 FC 56 02 00  PatchEntry2 DC L:theDirtyDeed2
2406 53FC
2407 53FC EA           theDirtyDeed2 NOP   
2408 53FD A0 06 00              ldy   #ItemFlag
2409 5400 B7 24                 lda   [<itemptr],y
2410 5402 29 00 04              and   #I_NEWSTRUCTURE
2411 5405 D0 04                 bne   doPatch
2412 5407 5C 0C 73 FD           jml   BackIntoTextGuts
2413 540B
2414 540B 4B F4 15 57  doPatch  ROMCALL FixTextFace 
2415 5416
2416 5416              ;
2417 5416              ; --- Dividing line (not the same thing as an underline) -------------
2418 5416              ;
2419 5416 20 3C 50              jsr   getistrg
2420 5419
2421 5419 A7 64                 lda   [<strg_ptr]              Get the first two bytes from the string
2422 541B C9 01 2D              cmp   #$2D01                   Dividing line flag?
2423 541E D0 1C                 bne   main_text
2424 5420
2425 5420 A5 10                 lda   <rect+y2                 Center line in item.
2426 5422 38                    sec   
2427 5423 E5 0C                 sbc   <rect+y1
2428 5425 4A                    lsr   a
2429 5426 18                    clc   
2430 5427 65 0C                 adc   <rect+y1
2431 5429 A8                    tay   
2432 542A
2433 542A A5 0E                 lda   <rect+x1                 Draw from wall to wall.
2434 542C A6 12                 ldx   <rect+x2
2435 542E CA                    dex                            Not past right side.
2436 542F 4B F4 39 57           ROMCALL hline Draw the dividing line and exit.
2437 543A 80 33                 bra   ck_dim
2438 543C
2439 543C              ;
2440 543C              ; --- Print item's text ----------------------------------------------
2441 543C              ;
2442 543C              main_text                               ; !!!! Font not defined yet !!!!
2443 543C A5 10                 lda   <rect+y2
2444 543E 38                    sec   
2445 543F E5 E8                 sbc   <descent
2446 5441 A8                    tay   Y = position to print item
2447 5442 5A                    phy   
2448 5443
2449 5443 A5 62                 lda   <text_width
2450 5445 18                    clc                            don't want any carry to be rotating in on us
2451 5446 6A                    ror   a
2452 5447 18                    clc   
2453 5448 65 0E                 adc   <rect+x1
2454 544A 65 62                 adc   <text_width              Indent 1 1/2 times the width of "w" to make room for mark
2455 544C 48                    pha                            x starting position of item's text
2456 544D 20 44 50              jsr   GetIconInfo
2457 5450 AA                    tax   
2458 5451 F0 08                 beq   @noIcon
2459 5453 18                    clc   
2460 5454 63 01                 adc   1,s                      Add in the width of the icon.
2461 5456 69 02 00              adc   #2                       Add some extra slop for spacing in between the icon.
2462 5459 83 01                 sta   1,s
2463 545B FA           @noIcon  plx   
2464 545C 7A                    ply   
2465 545D 4B F4 67 57           ROMCALL printstrg 
2466 5468
2467 5468 20 9A 56              jsr   DrawItemIcon             If the itemhas an icon this routine draws it, otherwise
2468 546B              ;                                       it just returns
2469 546B 5C 40 73 FD           jml   $FD7340                  Jump back into ROM (JSR ClearTextFace)
2470 546F
2471 546F 5C 91 73 FD  ck_dim   jml   $FD7391                  Jump back to label ck_dim in ROM.
2472 5473
2473 5473                       ENDP 
2474 5473
2475 5473
2476 5473              ;==========================================================================
2477 5473              ;
2478 5473              ; DoADirtyDeed3
2479 5473              ;
2480 5473              ; Patches return address from PtInRect call to return to the patch for
2481 5473              ; routine choose_item. Patches call "INSIDE" which is called by Choose_Item.
2482 5473              ;
2483 5473              ;==========================================================================
2484 5473              DoADirtyDeed3 PROC EXPORT 
2485 5473
2486 5473              tlRTL    equ   1
2487 5473              MenuMgrRTL equ   tlRTL+3
2488 5473              theRectPtr equ   MenuMgrRTL+3
2489 5473              thePointPtr equ   theRectPtr+4
2490 5473              theResult equ   thePointPtr+4
2491 5473
2492 5473              BackIntoINSIDE equ   $FD6CD1
2493 5473              ; the code leading up to this point...
2494 5473              ;	tay
2495 5473              ;
2496 5473              ;	pha		Space for result.
2497 5473              ;
2498 5473              ;	pea	0	Pass address of point to check.
2499 5473              ;	tdc
2500 5473              ;	clc
2501 5473              ;	adc	#yrat
2502 5473              ;	pha
2503 5473              ;
2504 5473              ;	phx	Pass address of RECT to check.
2505 5473              ;	phy
2506 5473              ;	_PtInRect
2507 5473
2508 5473 AF 82 57 02           lda   >PatchEntry3
2509 5477 83 04                 sta   MenuMgrRTL,s
2510 5479 AF 83 57 02           lda   >PatchEntry3+1
2511 547D 83 05                 sta   MenuMgrRTL+1,s
2512 547F 82 E0 20              brl   FinishPtInRect
2513 5482
2514 5482 86 57 02 00  PatchEntry3 DC L:theDirtyDeed3
2515 5486
2516 5486 EA           theDirtyDeed3 NOP   
2517 5487 A0 06 00              ldy   #itemflag
2518 548A B7 24                 lda   [<itemptr],y
2519 548C 29 00 04              and   #I_NEWSTRUCTURE
2520 548F D0 04                 bne   @doPatch
2521 5491 5C D1 6C FD           jml   BackIntoINSIDE           Right after PtInRect call.
2522 5495              @doPatch  
2523 5495 68                    pla   
2524 5496 FA                    plx                            Get rts from call to INSIDE off stack
2525 5497 AA                    tax   
2526 5498
2527 5498 D0 26                 bne   no_Scroller
2528 549A
2529 549A E6 50        lop5     inc   <count                   Next item
2530 549C A5 50                 lda   <count
2531 549E 4B F4 A8 57           ROMCALL calcitem Get item's RECT and pointer.
2532 54A9 F0 1C                 beq   not_found                Off end of menu?
2533 54AB
2534 54AB A2 00 00              ldx   #0                       Check if cursor is inside item.
2535 54AE 7B                    tdc   
2536 54AF 18                    clc   
2537 54B0 69 0C 00              adc   #rect
2538 54B3 4B F4 BD 57           ROMCALL inside 
2539 54BE F0 DA                 beq   lop5
2540 54C0              ;
2541 54C0              ; --- Cursor over item --------------------------------------------
2542 54C0              ;
2543 54C0 20 3C 50     no_scroller jsr   getistrg              All this just to patch this routine.
2544 54C3 5C A1 70 FD           jml   $FD70A1
2545 54C7
2546 54C7 5C C4 70 FD  not_found jml   $FD70C4
2547 54CB
2548 54CB                       ENDP 
2549 54CB
2550 54CB
2551 54CB              ;===========================================================================
2552 54CB              ;
2553 54CB              ;                   SetItemIcon
2554 54CB              ;
2555 54CB              ; This routine sets the ItemIcon field of the item structure referenced
2556 54CB              ; by the value now in the itemname field.
2557 54CB              ; The ItemFlag2 field in this structure is also set according to how 
2558 54CB              ; the icon will be referenced.
2559 54CB              ;
2560 54CB              ;   IN:  PUSH:WORD - refdescriptor for icon data
2561 54CB              ;        PUSH:LONG - reference to icon data
2562 54CB              ;        PUSH:WORD - item ID 
2563 54CB              ;
2564 54CB              ;  OUT:  None.
2565 54CB              ;
2566 54CB              ;===========================================================================
2567 54CB              SetItemIcon PROC 
2568 54CB
2569 54CB              itemnum  equ   input
2570 54CB              iconRef  equ   itemnum+2
2571 54CB              iconVerb equ   iconRef+4
2572 54CB
2573 54CB 20 C8 4D              jsr   localstartup
2574 54CE 4B F4 D8 57           ROMCALL lockmenubar 
2575 54D9 F0 4F                 beq   exit2
2576 54DB
2577 54DB A3 0A                 lda   itemnum,s                Get item's ID.
2578 54DD 4B F4 E7 57           ROMCALL getiptr Now get its pointer.
2579 54E8 F0 35                 beq   exit                     Error?
2580 54EA
2581 54EA A0 06 00              ldy   #ItemFlag                First check if we've got our new style item record
2582 54ED B7 24                 lda   [<itemptr],y             that allows icons.
2583 54EF 29 00 04              and   #I_NEWSTRUCTURE
2584 54F2 F0 3A                 beq   ERROR                    If zero then item record not setup properly to handle icons.
2585 54F4
2586 54F4 4B F4 FE 57           ROMCALL badCache 
2587 54FF
2588 54FF 20 85 4F              jsr   GetStruct                Get pointer to this new structure.
2589 5502 A0 00 00              ldy   #ItemFlag2
2590 5505 B7 28                 lda   [<temptr],y
2591 5507 29 FC FF              and   #$FFFC                   Clear bits 0 and 1 which indicate how the icon will be
2592 550A 03 10                 ora   iconVerb,s               referenced and "OR" in new verb.
2593 550C 09 00 80              ora   #I_NOICON                Set bit in flag that tells us there is an icon associated w/item.
2594 550F 97 28                 sta   [<temptr],y
2595 5511
2596 5511 A0 06 00              ldy   #ItemIcon                Store the icon ref in our structure.
2597 5514 A3 0C                 lda   iconRef,s
2598 5516 97 28                 sta   [<temptr],y
2599 5518 A0 08 00              ldy   #ItemIcon+2
2600 551B A3 0E                 lda   iconRef+2,s
2601 551D 97 28                 sta   [<temptr],y
2602 551F
2603 551F 4B F4 29 58  exit     ROMCALL unlockmenubar 
2604 552A
2605 552A 5C C3 8F FD  exit2    jml   pop8bytes                no error
2606 552E
2607 552E 4B F4 38 58  ERROR    ROMCALL unlockmenubar 
2608 5539 A0 03 0F              ldy   #NoStruct                error, "Invalid access of new item structure."
2609 553C 5C C6 8F FD           jml   epop8bytes
2610 5540
2611 5540                       ENDP 
2612 5540
2613 5540              ;===========================================================================
2614 5540              ;
2615 5540              ;                   GetItemIcon
2616 5540              ;
2617 5540              ;   IN:  PUSH:LONG - result containing reference to item's icon
2618 5540              ;        PUSH:WORD - item ID 
2619 5540              ;
2620 5540              ;  OUT:  LONG - Reference to item's icon. Result is zero if there is no icon.
2621 5540              ;
2622 5540              ;===========================================================================
2623 5540              GetItemIcon PROC 
2624 5540
2625 5540              itemnum  equ   input
2626 5540              result   equ   itemnum+2
2627 5540
2628 5540 20 C8 4D              jsr   localstartup
2629 5543 4B F4 4D 58           ROMCALL lockmenubar 
2630 554E F0 46                 beq   exit2
2631 5550
2632 5550 A9 00 00              lda   #0                       Initialize result to zero.
2633 5553 83 0C                 sta   result,s
2634 5555 83 0E                 sta   result+2,s
2635 5557
2636 5557 A3 0A                 lda   itemnum,s
2637 5559 4B F4 63 58           ROMCALL getiptr 
2638 5564 F0 25                 beq   exit                     item not found
2639 5566
2640 5566 A0 06 00              ldy   #ItemFlag                Check if correct flags are set to indicate use of the 
2641 5569 B7 24                 lda   [<itemptr],y             new structure.
2642 556B 29 00 04              and   #I_NEWSTRUCTURE
2643 556E F0 2A                 beq   ERROR                    If zero item record not setup to handle icons.
2644 5570
2645 5570 20 85 4F              jsr   GetStruct                Get reference to new structure and put in <temptr.
2646 5573 A0 00 00              ldy   #ItemFlag2               Make sure structure is using ItemIcon field. 
2647 5576 B7 28                 lda   [<temptr],y
2648 5578 29 00 80              and   #I_NOICON
2649 557B F0 0E                 beq   exit                     If not, then we're done.
2650 557D
2651 557D A0 06 00              ldy   #ItemIcon                 Get the reference to the icon and put in result.
2652 5580 B7 28                 lda   [<temptr],y
2653 5582 83 0C                 sta   result,s
2654 5584 A0 08 00              ldy   #ItemIcon+2
2655 5587 B7 28                 lda   [<temptr],y
2656 5589 83 0E                 sta   result+2,s
2657 558B
2658 558B 4B F4 95 58  exit     ROMCALL unlockmenubar 
2659 5596 5C AB 8F FD  exit2    jml   pop2bytes
2660 559A
2661 559A 4B F4 A4 58  ERROR    ROMCALL unlockmenubar 
2662 55A5 A0 03 0F              ldy   #NoStruct
2663 55A8 5C AE 8F FD           jml   epop2bytes
2664 55AC
2665 55AC                       ENDP 
2666 55AC
2667 55AC
2668 55AC              ;===========================================================================
2669 55AC              ;
2670 55AC              ;                   SetItemStruct
2671 55AC              ;
2672 55AC              ;   IN:  PUSH:WORD - ItemStructVerb, describes how STRUCT will be referenced
2673 55AC              ;        PUSH:LONG - ItemStructRef, ptr, hdl, resource ID to STRUCT
2674 55AC              ;        PUSH:WORD - ItemID, ID of item to set
2675 55AC              ;
2676 55AC              ;  OUT:  None.
2677 55AC              ;
2678 55AC              ; This call allows a menu item specified by ItemID to now be associated with
2679 55AC              ; a new structure. The ref. to this structure now resides in the ITEMNAME field
2680 55AC              ; of the item's record. Bits 10, 9, and 8 are automatically set. The ref to the
2681 55AC              ; item's name is then stored in this new structure.
2682 55AC              ;
2683 55AC              ;===========================================================================
2684 55AC              SetItemStruct PROC 
2685 55AC
2686 55AC              itemnum  equ   input
2687 55AC              ItemStructRef equ   itemnum+2
2688 55AC              ItemStructVerb equ   ItemStructRef+4
2689 55AC
2690 55AC 20 C8 4D              jsr   localstartup
2691 55AF 4B F4 B9 58           ROMCALL lockmenubar 
2692 55BA F0 56                 beq   exit2                    If a reg is zero upon return then no menubar present.
2693 55BC
2694 55BC A3 0A                 lda   itemnum,s
2695 55BE 4B F4 C8 58           ROMCALL getiptr Returns ptr to item record in <itemptr
2696 55C9 F0 3C                 beq   exit                     If a reg is zero upon return then item not found.
2697 55CB
2698 55CB 4B F4 D5 58           ROMCALL badCache 
2699 55D6
2700 55D6 A0 06 00              ldy   #ItemFlag                Set bit 10 in itemflag to indicate that the field
2701 55D9 A3 10                 lda   ItemStructVerb,s         itemname is now a Ref. to this new structure.
2702 55DB EB                    xba                            Also set bits 8 and 9 to reflect how this structure
2703 55DC 09 00 04              ora   #I_NEWSTRUCTURE          will be referenced.
2704 55DF 17 24                 ora   [<itemptr],y
2705 55E1 97 24                 sta   [<itemptr],y
2706 55E3
2707 55E3 A0 0A 00              ldy   #ItemName+2              Save ref. to item's name on stack.
2708 55E6 B7 24                 lda   [<itemptr],y
2709 55E8 48                    pha   
2710 55E9 A0 08 00              ldy   #ItemName
2711 55EC B7 24                 lda   [<itemptr],y
2712 55EE 48                    pha   
2713 55EF
2714 55EF A3 10                 lda   ItemStructRef+4,s        Now store the ref. to the struct in the itemname field.
2715 55F1 97 24                 sta   [<itemptr],y
2716 55F3 A3 12                 lda   ItemStructRef+6,s
2717 55F5 C8                    iny   
2718 55F6 C8                    iny   
2719 55F7 97 24                 sta   [<itemptr],y
2720 55F9
2721 55F9 20 85 4F              jsr   GetStruct                Returns a ptr to the new structure in <temptr.
2722 55FC A0 02 00              ldy   #ItemName2               Store itemname in its new location.
2723 55FF 68                    pla   
2724 5600 97 28                 sta   [<temptr],y
2725 5602 68                    pla   
2726 5603 C8                    iny   
2727 5604 C8                    iny   
2728 5605 97 28                 sta   [<temptr],y
2729 5607
2730 5607 4B F4 11 59  exit     ROMCALL unlockmenubar 
2731 5612 5C C3 8F FD  exit2    jml   pop8bytes
2732 5616
2733 5616                       ENDP 
2734 5616
2735 5616
2736 5616              ;===========================================================================
2737 5616              ;
2738 5616              ;                   GetItemStruct
2739 5616              ;
2740 5616              ;   IN:  PUSH:LONG - Result, ref to item's struct is returned here
2741 5616              ;        PUSH:WORD - ItemID, ID of item's struct you want
2742 5616              ;
2743 5616              ;  OUT:  None.
2744 5616              ;
2745 5616              ; If bit 10 is set, then this call returns the reference to the item's 
2746 5616              ; structure.
2747 5616              ;
2748 5616              ;===========================================================================
2749 5616              GetItemStruct PROC 
2750 5616
2751 5616              itemnum  equ   input
2752 5616              result   equ   itemnum+2
2753 5616
2754 5616 20 C8 4D              jsr   localstartup
2755 5619 4B F4 23 59           ROMCALL lockmenubar 
2756 5624 F0 38                 beq   exit2                    If a-reg is zero upon return then no menubar present.
2757 5626
2758 5626 A9 00 00              lda   #0                       Initialize result to zero for time being.
2759 5629 83 0C                 sta   result,s
2760 562B 83 0E                 sta   result+2,s
2761 562D
2762 562D A3 0A                 lda   itemnum,s
2763 562F 4B F4 39 59           ROMCALL getiptr 
2764 563A F0 17                 beq   exit                     If a-reg is zero upon return then item not found.
2765 563C
2766 563C A0 06 00              ldy   #ItemFlag                See if item has additional structure associated with it.
2767 563F B7 24                 lda   [<itemptr],y
2768 5641 29 00 04              and   #I_NEWSTRUCTURE
2769 5644 F0 0D                 beq   exit
2770 5646
2771 5646 A0 08 00              ldy   #ItemName
2772 5649 B7 24                 lda   [<itemptr],y
2773 564B 83 0C                 sta   result,s
2774 564D C8                    iny   
2775 564E C8                    iny   
2776 564F B7 24                 lda   [<itemptr],y
2777 5651 83 0E                 sta   result+2,s
2778 5653
2779 5653 4B F4 5D 59  exit     ROMCALL unlockmenubar 
2780 565E 5C AB 8F FD  exit2    jml   pop2bytes
2781 5662
2782 5662                       ENDP 
2783 5662
2784 5662
2785 5662              ;===========================================================================
2786 5662              ;
2787 5662              ;                   RemoveItemStruct
2788 5662              ;
2789 5662              ;   IN:  PUSH:WORD - ItemID, ID of item's struct you want removed
2790 5662              ;
2791 5662              ;  OUT:  None.
2792 5662              ;
2793 5662              ;===========================================================================
2794 5662              RemoveItemStruct PROC 
2795 5662
2796 5662              itemnum  equ   input
2797 5662
2798 5662 20 C8 4D              jsr   localstartup
2799 5665 4B F4 6F 59           ROMCALL lockmenubar 
2800 5670 F0 51                 beq   exit2                    If a-reg is zero upon return then no menubar present.
2801 5672
2802 5672 A3 0A                 lda   itemnum,s
2803 5674 4B F4 7E 59           ROMCALL getiptr 
2804 567F F0 37                 beq   exit                     If a-reg is zero upon return then item not found.
2805 5681
2806 5681 A0 06 00              ldy   #ItemFlag
2807 5684 B7 24                 lda   [<itemptr],y
2808 5686 29 00 04              and   #I_NEWSTRUCTURE          First check to make sure there is a structure.
2809 5689 F0 2D                 beq   exit
2810 568B
2811 568B 4B F4 95 59           ROMCALL badCache 
2812 5696
2813 5696 20 85 4F              jsr   GetStruct                Move itemname ref from the structure back to the
2814 5699 A0 04 00              ldy   #ItemName2+2             item's record.
2815 569C B7 28                 lda   [<temptr],y
2816 569E AA                    tax   
2817 569F A0 02 00              ldy   #ItemName2
2818 56A2 B7 28                 lda   [<temptr],y
2819 56A4 A0 08 00              ldy   #ItemName
2820 56A7 97 24                 sta   [<itemptr],y
2821 56A9 C8                    iny   
2822 56AA C8                    iny   
2823 56AB 8A                    txa   
2824 56AC 97 24                 sta   [<itemptr],y
2825 56AE
2826 56AE A0 06 00              ldy   #ItemFlag
2827 56B1 B7 24                 lda   [<itemptr],y
2828 56B3 29 FF F8              and   #$F8FF                   Clear bits 10, 9, and 8.
2829 56B6 97 24                 sta   [<itemptr],y
2830 56B8
2831 56B8 4B F4 C2 59  exit     ROMCALL unlockmenubar 
2832 56C3 5C AB 8F FD  exit2    jml   pop2bytes
2833 56C7
2834 56C7                       ENDP 
2835 56C7
2836 56C7              ;===========================================================================
2837 56C7              ;
2838 56C7              ;                   GetItemFlag2
2839 56C7              ;
2840 56C7              ;   IN:  PUSH:WORD - Result
2841 56C7              ;        PUSH:WORD - ItemID, ID of item that you want flag for.
2842 56C7              ;
2843 56C7              ;  OUT:  None.
2844 56C7              ;
2845 56C7              ;===========================================================================
2846 56C7              GetItemFlag2 PROC 
2847 56C7
2848 56C7              itemnum  equ   input
2849 56C7              result   equ   itemnum+2
2850 56C7
2851 56C7 20 C8 4D              jsr   localstartup
2852 56CA 4B F4 D4 59           ROMCALL lockmenubar 
2853 56D5 F0 33                 beq   exit2                    If a-reg is zero upon return then no menubar present.
2854 56D7
2855 56D7 A9 00 00              lda   #0
2856 56DA 83 0C                 sta   result,s
2857 56DC
2858 56DC A3 0A                 lda   itemnum,s
2859 56DE 4B F4 E8 59           ROMCALL getiptr 
2860 56E9 F0 14                 beq   exit                     If a-reg is zero upon return then item not found.
2861 56EB
2862 56EB A0 06 00              ldy   #ItemFlag
2863 56EE B7 24                 lda   [<itemptr],y
2864 56F0 29 00 04              and   #I_NEWSTRUCTURE
2865 56F3 F0 0A                 beq   exit
2866 56F5
2867 56F5 20 85 4F              jsr   GetStruct
2868 56F8 A0 00 00              ldy   #ItemFlag2
2869 56FB B7 28                 lda   [<temptr],y
2870 56FD 83 0C                 sta   result,s
2871 56FF
2872 56FF 4B F4 09 5A  exit     ROMCALL unlockmenubar 
2873 570A 5C AB 8F FD  exit2    jml   pop2bytes
2874 570E
2875 570E                       ENDP 
2876 570E
2877 570E
2878 570E              ;===========================================================================
2879 570E              ;
2880 570E              ;                   SetItemFlag2
2881 570E              ;
2882 570E              ;   IN:  PUSH:WORD - ItemFlag2, new value you want ItemFlag2 to be set to
2883 570E              ;        PUSH:WORD - ItemID, ID of item that you want to set.
2884 570E              ;
2885 570E              ;  OUT:  None.
2886 570E              ;
2887 570E              ;===========================================================================
2888 570E              SetItemFlag2 PROC 
2889 570E
2890 570E              itemnum  equ   input
2891 570E              NewItemFlag2 equ   ItemNum+2
2892 570E
2893 570E 20 C8 4D              jsr   localstartup
2894 5711 4B F4 1B 5A           ROMCALL lockmenubar 
2895 571C F0 39                 beq   exit2                    If a-reg is zero upon return then no menubar present.
2896 571E
2897 571E A3 0A                 lda   itemnum,s
2898 5720 4B F4 2A 5A           ROMCALL getiptr 
2899 572B F0 1F                 beq   exit                     If a-reg is zero upon return then item not found.
2900 572D
2901 572D A0 06 00              ldy   #ItemFlag
2902 5730 B7 24                 lda   [<itemptr],y
2903 5732 29 00 04              and   #I_NEWSTRUCTURE
2904 5735 F0 15                 beq   exit
2905 5737
2906 5737 4B F4 41 5A           ROMCALL badCache 
2907 5742
2908 5742 20 85 4F              jsr   GetStruct
2909 5745 A0 00 00              ldy   #ItemFlag2
2910 5748 A3 0C                 lda   NewItemFlag2,s
2911 574A 97 28                 sta   [<temptr],y
2912 574C
2913 574C 4B F4 56 5A  exit     ROMCALL unlockmenubar 
2914 5757 5C B3 8F FD  exit2    jml   pop4bytes
2915 575B
2916 575B                       ENDP 
2917 575B
2918 575B
2919 575B              ;===========================================================================
2920 575B              ;
2921 575B              ;                   GetItemWidth
2922 575B              ;
2923 575B              ;   IN:  PUSH:WORD - ItemFlag2, new value you want ItemFlag2 to be set to
2924 575B              ;        PUSH:WORD - ItemID, ID of item that you want to set.
2925 575B              ;
2926 575B              ;  OUT:  None.
2927 575B              ;
2928 575B              ;
2929 575B              ; 21-Sep-90 Dave Lyons
2930 575B              ;
2931 575B              ; Harry added this to the Menu Manager tool, but not to the ROM 3 patch,
2932 575B              ; so here's where it will be.
2933 575B              ;
2934 575B              ;===========================================================================
2935 575B              GetItemWidth proc 
2936 575B
2937 575B 00 00                 brk   0                        ;%%%
2938 575D
2939 575D                       EndP 
2940 575D
2941 575D              ;===========================================================================
2942 575D              ;
2943 575D              ;                   SetMItem
2944 575D              ;
2945 575D              ;                   Set new item string.
2946 575D              ;
2947 575D              ;   IN:    PUSH:LONG - pointer to new string.
2948 575D              ;          PUSH:WORD - item's ID.
2949 575D              ;
2950 575D              ;  OUT:    None.
2951 575D              ;
2952 575D              ;===========================================================================
2953 575D              SetMItem PROC 
2954 575D
2955 575D              itemnum  equ   input
2956 575D              strg     equ   itemnum+2
2957 575D
2958 575D              BackIntoSetMItem equ   $FD7A9A          Back into SetMItem call in ROM.
2959 575D
2960 575D 20 C8 4D              jsr   localstartup
2961 5760 4B F4 6A 5A           ROMCALL lockmenubar <barptr = (<barHand), bar & menus locked.
2962 576B F0 60                 beq   exit2
2963 576D
2964 576D A3 0A                 lda   itemnum,s                Get pointer to item's record and store in <itemptr.
2965 576F 4B F4 79 5A           ROMCALL getiptr 
2966 577A F0 46                 beq   exit
2967 577C
2968 577C A0 06 00              ldy   #itemflag                Check if item has new structure associated with it.
2969 577F B7 24                 lda   [<itemptr],y
2970 5781 29 00 04              and   #I_NEWSTRUCTURE
2971 5784 D0 04                 bne   @newWay
2972 5786
2973 5786 5C 9A 7A FD           jml   BackIntoSetMItem
2974 578A              @newWay   
2975 578A 4B F4 94 5A           ROMCALL badCache Set cache to bad if menu has a cache.
2976 5795
2977 5795 A0 06 00              ldy   #ItemFlag                Since the reference to the item name is a ptr to that name
2978 5798 B7 24                 lda   [<itemptr],y             we clear the first two bits of the item flag
2979 579A 29 FF 3F              and   #CLEAR_TWO_BITS
2980 579D 97 24                 sta   [<itemptr],y
2981 579F
2982 579F A3 0C                 lda   strg,s                   Pass pointer to string.
2983 57A1 85 64                 sta   <strg_ptr
2984 57A3 A3 0E                 lda   strg+2,s
2985 57A5 85 66                 sta   <strg_ptr+2
2986 57A7
2987 57A7 4B F4 B1 5A           ROMCALL parse_strg Get and set length of string.
2988 57B2
2989 57B2 20 85 4F              jsr   GetStruct                Get ptr to item's additional structure.
2990 57B5 A0 02 00              ldy   #itemName2
2991 57B8 A5 64                 lda   <strg_ptr
2992 57BA 97 28                 sta   [<temptr],y
2993 57BC A5 66                 lda   <strg_ptr+2
2994 57BE C8                    iny   
2995 57BF C8                    iny   
2996 57C0 97 28                 sta   [<temptr],y
2997 57C2
2998 57C2 4B F4 CC 5A  exit     ROMCALL unlockmenubar Leave menu bar & menus unlocked.
2999 57CD
3000 57CD 5C BB 8F FD  exit2    jml   pop6bytes
3001 57D1
3002 57D1                       ENDP 
3003 57D1
3004 57D1
3005 57D1              ;===========================================================================
3006 57D1              ;
3007 57D1              ;                   GetItem
3008 57D1              ;
3009 57D1              ;                   Get item's string.
3010 57D1              ;
3011 57D1              ;   IN:  PUSH:WORD - item's ID.
3012 57D1              ;
3013 57D1              ;  OUT:  LONG - pointer to item's text.
3014 57D1              ;
3015 57D1              ;===========================================================================
3016 57D1              GetItem  PROC 
3017 57D1
3018 57D1              itemnum  equ   input
3019 57D1              result   equ   itemnum+2
3020 57D1
3021 57D1              BackIntoGetItem1 equ   $FD7AD3          Back into GetItem if item not found.
3022 57D1              BackIntoGetItem2 equ   $FD7ADC          Back into GetItem if item doesn't have new struct associated with it.
3023 57D1
3024 57D1 20 C8 4D              jsr   localstartup
3025 57D4 4B F4 DE 5A           ROMCALL lockmenubar <barptr = (<barHand), bar & menus locked.
3026 57DF F0 3C                 beq   exit2
3027 57E1
3028 57E1 A3 0A                 lda   itemnum,s                Get pointer to item's record and store in <itemptr.
3029 57E3 4B F4 ED 5A           ROMCALL getiptr 
3030 57EE D0 04                 bne   foundSomething
3031 57F0 5C D3 7A FD           jml   BackIntoGetItem1
3032 57F4
3033 57F4 A0 06 00     foundSomething ldy   #ItemFlag          First check is there is the new structure associated
3034 57F7 B7 24                 lda   [<itemptr],y             with this item.
3035 57F9 29 00 04              and   #I_NEWSTRUCTURE
3036 57FC D0 04                 bne   @newWay
3037 57FE 5C DC 7A FD           jml   BackIntoGetItem2
3038 5802
3039 5802 20 85 4F     @newWay  jsr   GetStruct                Get ptr to item's additional structure.
3040 5805 A0 02 00              ldy   #itemName2
3041 5808 B7 28                 lda   [<temptr],y
3042 580A 83 0C                 sta   result,s
3043 580C C8                    iny   
3044 580D C8                    iny   
3045 580E B7 28                 lda   [<temptr],y
3046 5810 83 0E                 sta   result+2,s
3047 5812
3048 5812 4B F4 1C 5B           ROMCALL unlockmenubar 
3049 581D 5C AB 8F FD  exit2    jml   pop2bytes
3050 5821
3051 5821                       ENDP 
3052 5821
3053 5821              ;===========================================================================
3054 5821              ;
3055 5821              ; EnableMItem patch
3056 5821              ;
3057 5821              ; 22-Oct-90 Dave Lyons
3058 5821              ;
3059 5821              ; Return an error if the Menu Manager isn't started up, because some
3060 5821              ; stupid application is calling this before it starts any tools.
3061 5821              ;
3062 5821              ;===========================================================================
3063 5821              EnableMItem proc 
3064 5821
3065 5821 A8                    tay   
3066 5822 F0 04                 beq   ReturnError0001
3067 5824 5C 62 7B FD           jml   >$fd7b62
3068 5828
3069 5828                       entry ReturnError0001 
3070 5828 A9 01 00     ReturnError0001 lda   #1
3071 582B 38                    sec   
3072 582C 6B                    rtl   
3073 582D
3074 582D                       endp 
3075 582D
3076 582D
3077 582D              ;===========================================================================
3078 582D              ;
3079 582D              ; DisableMItem patch
3080 582D              ;
3081 582D              ; 22-Oct-90 Dave Lyons
3082 582D              ;
3083 582D              ; Return an error if the Menu Manager isn't started up, because some
3084 582D              ; stupid application is calling this before it starts any tools.
3085 582D              ;
3086 582D              ;===========================================================================
3087 582D              DisableMItem proc 
3088 582D                       import ReturnERror0001 
3089 582D
3090 582D A8                    tay   
3091 582E F0 F8                 beq   ReturnError0001
3092 5830 5C 76 7B FD           jml   >$fd7b76
3093 5834
3094 5834                       endp 
3095 5834
3096 5834
3097 5834              ;===========================================================================
3098 5834              ;
3099 5834              ;                   SetMItemName
3100 5834              ;
3101 5834              ;                   Set item's string.
3102 5834              ;
3103 5834              ;   IN:    PUSH:LONG - pointer to pascal string.
3104 5834              ;          PUSH:WORD - item's ID.
3105 5834              ;
3106 5834              ;  OUT:    None.
3107 5834              ;
3108 5834              ;===========================================================================
3109 5834              SetMItemName PROC 
3110 5834
3111 5834              itemnum  equ   input
3112 5834              newName  equ   itemnum+2
3113 5834
3114 5834              BackToSetMItemName equ   $FD7B42
3115 5834
3116 5834 20 C8 4D              jsr   localstartup             Do startup initialization for tool call.
3117 5837 4B F4 41 5B           ROMCALL lockMenuBar <barPtr = (<barHand), bar & menus locked.
3118 5842 F0 4D                 beq   exit2                    Is there a current menu bar?
3119 5844
3120 5844 A3 0A                 lda   itemnum,s                Get item's ID.
3121 5846 4B F4 50 5B           ROMCALL getiptr Now get its pointer.
3122 5851 F0 33                 beq   exit                     Error?
3123 5853
3124 5853 A0 06 00              ldy   #ItemFlag                First check if item has new structure associated with it.
3125 5856 B7 24                 lda   [<itemptr],y
3126 5858 29 00 04              and   #I_NEWSTRUCTURE
3127 585B D0 04                 bne   @newWay
3128 585D
3129 585D 5C 42 7B FD           jml   BackToSetMItemName
3130 5861              @newWay   
3131 5861 4B F4 6B 5B           ROMCALL badCache Set cache to bad if menu has a cache.
3132 586C
3133 586C A0 06 00              ldy   #ItemFlag                Get flag of current item and clear the first two bits
3134 586F B7 24                 lda   [<itemptr],y             We need to clear them because later on we're going to
3135 5871 29 FF 3F              and   #CLEAR_TWO_BITS          'OR' it with the new value
3136 5874 97 24                 sta   [<itemptr],y
3137 5876
3138 5876 20 85 4F              jsr   GetStruct                Get the ptr to the new structure
3139 5879 A0 02 00              ldy   #itemName2               and store the ptr in <temptr.
3140 587C A3 0C                 lda   newName,s
3141 587E 97 28                 sta   [<temptr],y
3142 5880 C8                    iny   
3143 5881 C8                    iny   
3144 5882 A3 0E                 lda   newName+2,s
3145 5884 97 28                 sta   [<temptr],y
3146 5886
3147 5886 4B F4 90 5B  exit     ROMCALL unlockMenuBar Leave menu bar & menus unlocked.
3148 5891
3149 5891 5C BB 8F FD  exit2    jml   pop6bytes                no error
3150 5895
3151 5895                       ENDP 
3152 5895
3153 5895
3154 5895              ;===========================================================================
3155 5895              ;
3156 5895              ;                   SetMItemName2
3157 5895              ;
3158 5895              ;  IN: PUSH:WORD - refdescriptor, describes what next long will be
3159 5895              ;      PUSH:LONG - titleref, pointer, handle, or resource ID of title name
3160 5895              ;      PUSH:WORD - menuitem, ID of item that will get new title
3161 5895              ;
3162 5895              ; OUT: None.
3163 5895              ;
3164 5895              ;===========================================================================
3165 5895              SetMItemName2 PROC 
3166 5895
3167 5895              itemnum  equ   input
3168 5895              titleref equ   itemnum+2                ; ptr, hdl, resource ID of new item name
3169 5895              refdescriptor equ   titleref+4
3170 5895
3171 5895              BackToSetMItemName2 equ   $FD7AFE
3172 5895              BackIntoCall equ   $FD7B0E
3173 5895
3174 5895 20 C8 4D              jsr   localstartup
3175 5898 4B F4 A2 5B           ROMCALL lockMenuBar 
3176 58A3 F0 47                 beq   exit2
3177 58A5
3178 58A5 A3 0A                 lda   itemnum,s                Get item's ID.
3179 58A7 4B F4 B1 5B           ROMCALL getiptr Now get its pointer (in <itemptr).
3180 58B2 F0 2D                 beq   exit                     Error?
3181 58B4
3182 58B4 A0 06 00              ldy   #ItemFlag
3183 58B7 B7 24                 lda   [<itemptr],y
3184 58B9 29 00 04              and   #I_NEWSTRUCTURE
3185 58BC D0 04                 bne   @newWay
3186 58BE
3187 58BE 5C FE 7A FD           jml   BackToSetMItemName2
3188 58C2
3189 58C2 4B F4 CC 5B  @newWay  ROMCALL badCache Set cache to bad if menu has a cache.
3190 58CD
3191 58CD 20 85 4F              jsr   GetStruct                There is so get the ptr to the new structure
3192 58D0 A0 02 00              ldy   #itemName2               and store the ptr in <temptr.
3193 58D3 A3 0C                 lda   titleref,s
3194 58D5 97 28                 sta   [<temptr],y
3195 58D7 C8                    iny   
3196 58D8 C8                    iny   
3197 58D9 A3 0E                 lda   titleref+2,s
3198 58DB 97 28                 sta   [<temptr],y
3199 58DD
3200 58DD 5C 0E 7B FD           jml   BackIntoCall
3201 58E1
3202 58E1 4B F4 EB 5B  exit     ROMCALL unlockMenuBar 
3203 58EC
3204 58EC 5C C3 8F FD  exit2    jml   pop8bytes
3205 58F0
3206 58F0                       ENDP 
3207 58F0
3208 58F0
3209 58F0
3210 58F0
3211 58F0              ;===========================================================================
3212 58F0              ;
3213 58F0              ;                   SetMItem2
3214 58F0              ;
3215 58F0              ;  IN: PUSH:WORD - refdescriptor, describes what next long is (0=ptr, 1=hdl, 2=res ID)
3216 58F0              ;      PUSH:LONG - titleref, pointer, handle or resource ID of a resource menu item
3217 58F0              ;      PUSH:WORD - item's ID
3218 58F0              ;
3219 58F0              ; OUT: None.
3220 58F0              ;
3221 58F0              ;===========================================================================
3222 58F0              SetMItem2 PROC 
3223 58F0
3224 58F0              itemnum  equ   input
3225 58F0              titleref equ   itemnum+2                ; ptr, hdl, resource ID of new item name
3226 58F0              refdescriptor equ   titleref+4
3227 58F0
3228 58F0              myTemp   equ   work
3229 58F0              newFlag  equ   myTemp+4
3230 58F0
3231 58F0              BackInSetMItem2 equ   $FD7A21
3232 58F0
3233 58F0 20 C8 4D              jsr   localstartup
3234 58F3 4B F4 FD 5B           ROMCALL lockmenubar 
3235 58FE D0 03                 bne   @FoundMenuBar
3236 5900 82 A2 00              brl   exit2
3237 5903              @FoundMenuBar  
3238 5903 A3 0A                 lda   itemnum,s                Is the item that we specified in any of the menus?
3239 5905 4B F4 0F 5C           ROMCALL getiptr Put the ptr to the item record in <itemptr.
3240 5910 D0 03                 bne   @FoundItem
3241 5912 82 85 00              brl   exit                     Item not found so just beat it.
3242 5915              @FoundItem  
3243 5915 A0 06 00              ldy   #ItemFlag                First check if the new structure is associated with this item.
3244 5918 B7 24                 lda   [<itemptr],y
3245 591A 29 00 04              and   #I_NEWSTRUCTURE
3246 591D D0 04                 bne   @newWay
3247 591F
3248 591F 5C 21 7A FD           jml   BackInSetMItem2 Nothing new so just run the old code.
3249 5923              @newWay   
3250 5923 4B F4 2D 5C           ROMCALL badCache Set cache to bad if menu has a cache
3251 592E
3252 592E A0 06 00              ldy   #ItemFlag                Get flag of current item and clear the first two bits
3253 5931 B7 24                 lda   [<itemptr],y             We need to clear them because latter on we're going to
3254 5933 29 FF 3F              and   #CLEAR_TWO_BITS          'OR' it with the new value
3255 5936 97 24                 sta   [<itemptr],y
3256 5938
3257 5938 A3 0C                 lda   titleref,s
3258 593A 85 EA                 sta   <myTemp
3259 593C A3 0E                 lda   titleref+2,s
3260 593E 85 EC                 sta   <myTemp+2
3261 5940
3262 5940 A3 10                 lda   refdescriptor,s
3263 5942 0A                    asl   a
3264 5943 AA                    tax   
3265 5944 7C 47 5C              jmp   (table,x)
3266 5947
3267 5947 70 5C        table    DC W:pointer
3268 5949 64 5C                 DC W:handle
3269 594B 4D 5C                 DC W:resourceID
3270 594D
3271 594D A3 0E        resourceID lda   titleref+2,s           Load the menu item resource and get the handle to it
3272 594F AA                    tax   
3273 5950 A3 0C                 lda   titleref,s
3274 5952 A0 0A 80              ldy   #rMenuItem
3275 5955 4B F4 5F 5C           ROMCALL LoadnRelease 
3276 5960 85 EA                 sta   <myTemp                  Store handle back on my direct page
3277 5962 86 EC                 stx   <myTemp+2
3278 5964
3279 5964 A0 02 00     handle   ldy   #2                       Dereference the menu item handle and put ptr back
3280 5967 B7 EA                 lda   [<myTemp],y              into my direct page
3281 5969 AA                    tax   
3282 596A A7 EA                 lda   [<myTemp]
3283 596C 85 EA                 sta   <myTemp
3284 596E 86 EC                 stx   <myTemp+2
3285 5970
3286 5970 A0 08 00     pointer  ldy   #resItemFlag             Find out how the item name is being referenced, is it a
3287 5973 B7 EA                 lda   [<myTemp],y              pointer, handle, or resource ID?
3288 5975 29 00 C0              and   #FIRST_TWO_BITS
3289 5978 85 EE                 sta   <newFlag
3290 597A
3291 597A A0 06 00              ldy   #ItemFlag
3292 597D B7 24                 lda   [<itemptr],y
3293 597F 05 EE                 ora   <newFlag
3294 5981 97 24                 sta   [<itemptr],y             Update the item flag in our item record
3295 5983
3296 5983 20 85 4F              jsr   GetStruct                Get the ptr to the new structure and store the ptr in <temptr.
3297 5986 A0 0A 00              ldy   #resItemName             Store new itemname in new structure.
3298 5989 B7 EA                 lda   [<myTemp],y
3299 598B A0 02 00              ldy   #ItemName2
3300 598E 97 28                 sta   [<temptr],y
3301 5990 A0 0C 00              ldy   #resItemName+2
3302 5993 B7 EA                 lda   [<myTemp],y
3303 5995 A0 0A 00              ldy   #ItemName+2
3304 5998 97 28                 sta   [<temptr],y
3305 599A
3306 599A 4B F4 A4 5C  exit     ROMCALL unlockmenubar 
3307 59A5
3308 59A5 5C C3 8F FD  exit2    jml   pop8bytes
3309 59A9
3310 59A9                       ENDP 
3311 59A9
3312 59A9
3313 59A9                       END   
